/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.cog_crank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.lopyluna.dndesires.content.blocks.kinetics.cog_crank.CogCrankBE;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import dev.lopyluna.dndesires.register.DesiresShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CogCrankBlock
extends RotatedPillarKineticBlock
implements IBE<CogCrankBE>,
ICogWheel,
ProperWaterloggedBlock {
    boolean isLarge;

    protected CogCrankBlock(boolean large, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.isLarge = large;
    }

    public static CogCrankBlock small(BlockBehaviour.Properties properties) {
        return new CogCrankBlock(false, properties);
    }

    public static CogCrankBlock large(BlockBehaviour.Properties properties) {
        return new CogCrankBlock(true, properties);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShaper small = DesiresShapes.shape(DesiresShapes.cuboid(2.0, 6.0, 2.0, 14.0, 10.0, 14.0)).forAxis();
        VoxelShaper large = DesiresShapes.shape(DesiresShapes.cuboid(0.0, 6.0, 0.0, 16.0, 10.0, 16.0)).forAxis();
        return (this.isLarge ? large : small).get((Direction.Axis)state.getValue((Property)AXIS));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, WATERLOGGED});
    }

    public int getRotationSpeed() {
        return this.isLarge ? 16 : 32;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ICogWheel cog;
        BlockItem bi;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (item = (bi = (BlockItem)item).getBlock()) instanceof ICogWheel && (cog = (ICogWheel)item).isDedicatedCogWheel() || player.isSpectator()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> be.turn(player.isShiftKeyDown()));
        if (!stack.is((Item)AllItems.EXTENDO_GRIP.get())) {
            player.causeFoodExhaustion((float)this.getRotationSpeed() * AllConfigs.server().kinetics.crankHungerMultiplier.getF());
        }
        if (player.getFoodData().getFoodLevel() == 0) {
            AllAdvancements.HAND_CRANK.awardTo(player);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)level, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS)));
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    protected Direction.Axis getAxisForPlacement(BlockPlaceContext context) {
        Direction.Axis preferredAxis;
        Direction face = context.getClickedFace();
        Direction.Axis faceAxis = face.getAxis();
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            return faceAxis;
        }
        Level level = context.getLevel();
        BlockState stateBelow = level.getBlockState(context.getClickedPos().below());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.has(stateBelow) && this.isLargeCog()) {
            return stateBelow.getValue(SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        }
        BlockPos placedOnPos = context.getClickedPos().relative(face.getOpposite());
        BlockState placedAgainst = level.getBlockState(placedOnPos);
        Block block = placedAgainst.getBlock();
        if (block instanceof IRotate) {
            IRotate rot = (IRotate)block;
            if (ICogWheel.isSmallCog((BlockState)placedAgainst)) {
                return rot.getRotationAxis(placedAgainst);
            }
        }
        return (preferredAxis = CogCrankBlock.getPreferredAxis((BlockPlaceContext)context)) != null ? preferredAxis : faceAxis;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState defaultBlockState = this.withWater(this.defaultBlockState(), context);
        return (BlockState)defaultBlockState.setValue((Property)AXIS, (Comparable)this.getAxisForPlacement(context));
    }

    @NotNull
    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public Class<CogCrankBE> getBlockEntityClass() {
        return CogCrankBE.class;
    }

    public BlockEntityType<? extends CogCrankBE> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.COG_CRANK.get();
    }

    public boolean isLargeCog() {
        return this.isLarge;
    }

    public boolean isSmallCog() {
        return !this.isLarge;
    }

    public float getParticleTargetRadius() {
        return this.isLargeCog() ? 1.125f : 0.65f;
    }

    public float getParticleInitialRadius() {
        return this.isLargeCog() ? 1.0f : 0.75f;
    }

    public boolean isDedicatedCogWheel() {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

