/*
 * Decompiled with CFR 0.152.
 */
package qinomed.kubejsdelight.block.custom;

import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.KubeJSBlockProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import qinomed.kubejsdelight.block.custom.FeastBlockBuilder;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class BasicFeastBlockJS
extends FeastBlock {
    private int servings;
    public List<ResourceLocation> servingsList;
    public VoxelShape shape;

    public BasicFeastBlockJS(FeastBlockBuilder builder, int servings, List<ResourceLocation> servingsList) {
        super(builder.createProperties(), () -> (Item)BuiltInRegistries.ITEM.get(builder.servingsList.get(0)), builder.hasLeftovers);
        this.servings = servings;
        this.servingsList = servingsList;
        this.shape = BlockBuilder.createShape((List)builder.customShape);
        BlockBehaviour.Properties properties = this.properties;
        if (properties instanceof KubeJSBlockProperties) {
            KubeJSBlockProperties kjsProperties = (KubeJSBlockProperties)properties;
            properties = kjsProperties.blockBuilder;
            if (properties instanceof FeastBlockBuilder) {
                FeastBlockBuilder feastBlockBuilder = (FeastBlockBuilder)properties;
                this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)feastBlockBuilder.SERVINGS, (Comparable)Integer.valueOf(servings)));
            }
        }
    }

    public BasicFeastBlockJS(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties, servingItem, hasLeftovers);
    }

    public IntegerProperty getServingsProperty() {
        BlockBehaviour.Properties properties = this.properties;
        if (properties instanceof KubeJSBlockProperties) {
            KubeJSBlockProperties kjsProperties = (KubeJSBlockProperties)properties;
            properties = kjsProperties.blockBuilder;
            if (properties instanceof FeastBlockBuilder) {
                FeastBlockBuilder feastBuilder = (FeastBlockBuilder)properties;
                return feastBuilder.SERVINGS;
            }
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        BlockBehaviour.Properties properties = this.properties;
        if (properties instanceof KubeJSBlockProperties) {
            KubeJSBlockProperties kp = (KubeJSBlockProperties)properties;
            for (Property property : kp.blockBuilder.blockStateProperties) {
                builder.add(new Property[]{property});
            }
            kp.blockBuilder.blockStateProperties = Collections.unmodifiableSet(kp.blockBuilder.blockStateProperties);
        }
    }

    public int getMaxServings() {
        return this.servings;
    }

    public ItemStack getServingItem(BlockState state) {
        int serving = this.getMaxServings() - (Integer)state.getValue((Property)this.getServingsProperty());
        if (serving > this.servingsList.size() - 1) {
            return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.servingsList.get(this.servingsList.size() - 1)));
        }
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.servingsList.get(serving)));
    }
}

