/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod.corn_delight.block;

import cn.mcmod.corn_delight.item.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class PopcornBoxBlock
extends FeastBlock {
    protected static final VoxelShape BOX_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);

    public PopcornBoxBlock() {
        super(BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.YELLOW_WOOL), () -> ItemRegistry.CARAMEL_POPCORN.get(), true);
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide() && this.takeServing((LevelAccessor)level, pos, state, player, hand).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        return this.takeServing((LevelAccessor)level, pos, state, player, hand);
    }

    public ItemInteractionResult takeServing(LevelAccessor worldIn, BlockPos pos, BlockState state, Player player, InteractionHand handIn) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (servings == 0) {
            worldIn.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
            worldIn.destroyBlock(pos, true);
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack serving = this.getServingItem(state);
        ItemStack heldStack = player.getItemInHand(handIn);
        if (servings > 0) {
            if (heldStack.isEmpty()) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.getInventory().add(serving)) {
                    player.drop(serving, false);
                }
                if ((Integer)worldIn.getBlockState(pos).getValue((Property)SERVINGS) == 0) {
                    if (!player.getInventory().add(new ItemStack((ItemLike)Items.PAPER))) {
                        player.drop(new ItemStack((ItemLike)Items.PAPER), false);
                    }
                    worldIn.removeBlock(pos, false);
                }
                worldIn.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"corn_delight.block.popcorn.bearhand", (Object[])new Object[]{serving.getCraftingRemainingItem().getHoverName()}), true);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

