/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network;

import com.google.common.base.Preconditions;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ExecutionContext;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ServerPlayHelper {
    public static void sendMessageToOperators(Component message, ServerPlayer player) {
        MinecraftServer server = player.getServer();
        Preconditions.checkNotNull((Object)server, (Object)"The server was null when broadcasting config changes. This should not be possible...");
        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
            if (!server.getPlayerList().isOp(serverPlayer.getGameProfile())) continue;
            serverPlayer.sendSystemMessage(message);
        }
    }

    public static boolean canEditServerConfigs(ServerPlayer player) {
        ExecutionContext context = new ExecutionContext((Player)player);
        if (context.isClient()) {
            if (!context.isIntegratedServerOwnedByPlayer()) {
                Constants.LOG.warn("{} tried to request or update a server config, however is not the owner the integrated server", (Object)player.getName().getString());
                player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.unauthorized_request"));
                return false;
            }
            Constants.LOG.debug("{} was given access to edit server configs as they are the owner of the integrated server", (Object)player.getName().getString());
            return true;
        }
        if (context.isDedicatedServer()) {
            if (!Config.isDeveloperEnabled()) {
                Constants.LOG.warn("{} tried to request or update a server config, however developer mode is not enabled", (Object)player.getName().getString());
                player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.unauthorized_request"));
                ServerPlayHelper.sendMessageToOperators((Component)Component.translatable((String)"configured.chat.authorized_player").withStyle(ChatFormatting.RED), player);
                return false;
            }
            if (!context.isPlayerAnOperator() || !context.isDeveloperPlayer()) {
                Constants.LOG.warn("{} tried to request or update a server config, however they are not a developer", (Object)player.getName().getString());
                player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.unauthorized_request"));
                ServerPlayHelper.sendMessageToOperators((Component)Component.translatable((String)"configured.chat.authorized_player").withStyle(ChatFormatting.RED), player);
                return false;
            }
            return true;
        }
        return false;
    }
}

