/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.storage.player;

import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.entity.EntityTrackedData;
import dev.corgitaco.dataanchor.data.type.entity.SyncedPlayerTrackedData;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.rasanovum.viaromana.network.packets.SyncPlayerDataC2S;

public class PlayerTrackedData
extends SyncedPlayerTrackedData {
    private boolean chartingPath = false;
    private BlockPos lastNodePos = BlockPos.ZERO;
    private boolean receivedTutorial = false;
    private boolean seenLinkedSignToast = false;

    public PlayerTrackedData(TrackedDataKey<? extends EntityTrackedData> key, Player player) {
        super(key, player);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("ChartingPath", this.chartingPath);
        tag.putLong("LastNodePos", this.lastNodePos.asLong());
        tag.putBoolean("ReceivedTutorial", this.receivedTutorial);
        tag.putBoolean("SeenLinkedSignToast", this.seenLinkedSignToast);
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.contains("ChartingPath")) {
            this.chartingPath = tag.getBoolean("ChartingPath");
        }
        if (tag.contains("LastNodePos")) {
            this.lastNodePos = BlockPos.of((long)tag.getLong("LastNodePos"));
        }
        if (tag.contains("ReceivedTutorial")) {
            this.receivedTutorial = tag.getBoolean("ReceivedTutorial");
        }
        if (tag.contains("SeenLinkedSignToast")) {
            this.seenLinkedSignToast = tag.getBoolean("SeenLinkedSignToast");
        }
    }

    public CompoundTag writeToNetwork() {
        return this.save();
    }

    public void readFromNetwork(CompoundTag tag) {
        this.load(tag);
    }

    public void sync() {
        if (this.entity.level() instanceof ServerLevel) {
            super.sync();
        } else if (this.entity.level() instanceof ClientLevel) {
            PacketBroadcaster.C2S.sendToServer((Packet)new SyncPlayerDataC2S(this.entity.getId(), this.trackedDataKey.getId(), this.writeToNetwork()));
        }
    }

    public boolean isChartingPath() {
        return this.chartingPath;
    }

    public BlockPos getLastNodePos() {
        return this.lastNodePos;
    }

    public boolean hasReceivedTutorial() {
        return this.receivedTutorial;
    }

    public boolean hasSeenLinkedSignToast() {
        return this.seenLinkedSignToast;
    }

    public void setChartingPath(boolean value) {
        if (this.chartingPath != value) {
            this.chartingPath = value;
            this.sync();
        }
    }

    public void setLastNodePos(BlockPos value, boolean sync) {
        if (!this.lastNodePos.equals((Object)value)) {
            this.lastNodePos = value;
            if (sync) {
                this.sync();
            }
        }
    }

    public void setReceivedTutorial(boolean value) {
        if (this.receivedTutorial != value) {
            this.receivedTutorial = value;
            this.sync();
        }
    }

    public void setSeenLinkedSignToast(boolean value) {
        if (this.seenLinkedSignToast != value) {
            this.seenLinkedSignToast = value;
            this.sync();
        }
    }

    public void resetVariables() {
        boolean changed = false;
        if (this.chartingPath) {
            this.chartingPath = false;
            changed = true;
        }
        if (!this.lastNodePos.equals((Object)BlockPos.ZERO)) {
            this.lastNodePos = BlockPos.ZERO;
            changed = true;
        }
        if (changed) {
            this.sync();
        }
    }
}

