/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.storage.level;

import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.level.ServerLevelTrackedData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class LevelPixelTrackedData
extends ServerLevelTrackedData {
    private final Map<String, byte[]> pixelMap = new HashMap<String, byte[]>();

    public LevelPixelTrackedData(TrackedDataKey<? extends ServerLevelTrackedData> trackedDataKey, ServerLevel level) {
        super(trackedDataKey, level);
    }

    public CompoundTag save() {
        if (this.pixelMap.isEmpty()) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.put("pixel_map", (Tag)LevelPixelTrackedData.toNBT(this.pixelMap));
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.contains("pixel_map")) {
            this.pixelMap.clear();
            this.pixelMap.putAll(LevelPixelTrackedData.fromNBT(tag.getCompound("pixel_map")));
        }
    }

    public void setPixelBytes(ChunkPos pos, byte[] bytes) {
        String key = pos.x + "_" + pos.z;
        if (bytes != null && bytes.length == 256) {
            this.pixelMap.put(key, (byte[])bytes.clone());
        } else {
            this.pixelMap.remove(key);
        }
        this.markDirty();
    }

    public boolean isChunkTracked(ChunkPos pos) {
        return this.pixelMap.containsKey(pos.x + "_" + pos.z);
    }

    public Optional<byte[]> getPixelBytes(ChunkPos pos) {
        String key = pos.x + "_" + pos.z;
        byte[] bytes = this.pixelMap.get(key);
        return bytes != null && bytes.length == 256 ? Optional.of((byte[])bytes.clone()) : Optional.empty();
    }

    private static CompoundTag toNBT(Map<String, byte[]> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            tag.putByteArray(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    private static Map<String, byte[]> fromNBT(CompoundTag tag) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (String key : tag.getAllKeys()) {
            map.put(key, tag.getByteArray(key));
        }
        return map;
    }

    public void clearAll() {
        this.pixelMap.clear();
        this.markDirty();
    }
}

