/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.speed;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.StatInit;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public class SpeedHandler {
    public static final ResourceLocation PROXIMITY_SPEED_ID = VersionUtils.getLocation("viaromana", "node_proximity_speed");
    private static final double DISTANCE_THRESHOLD = 500000.0;
    private static final Map<UUID, BlockPos> lastPathWalkPositions = new HashMap<UUID, BlockPos>();

    public static void resetState(ServerPlayer player) {
        lastPathWalkPositions.remove(player.getUUID());
    }

    public static void onPlayerTick(ServerPlayer player) {
        boolean hasModifier;
        if (player.level().isClientSide) {
            return;
        }
        AttributeInstance speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute == null) {
            return;
        }
        boolean nearNode = false;
        PathGraph graph = PathGraph.getInstance((ServerLevel)player.level());
        if (graph != null) {
            Optional<Node> nearestNode = graph.getNearestNode(player.blockPosition(), CommonConfig.node_distance_minimum);
            nearNode = nearestNode.isPresent();
        }
        boolean bl = hasModifier = speedAttribute.getModifier(PROXIMITY_SPEED_ID) != null;
        if (nearNode && !hasModifier) {
            AttributeModifier modifier = new AttributeModifier(PROXIMITY_SPEED_ID, CommonConfig.fast_movement_speed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            speedAttribute.addPermanentModifier(modifier);
            lastPathWalkPositions.put(player.getUUID(), player.blockPosition());
        } else if (!nearNode && hasModifier) {
            speedAttribute.removeModifier(PROXIMITY_SPEED_ID);
            lastPathWalkPositions.remove(player.getUUID());
        } else if (nearNode && hasModifier) {
            BlockPos lastPos = lastPathWalkPositions.get(player.getUUID());
            BlockPos currentPos = player.blockPosition();
            if (lastPos == null) {
                lastPathWalkPositions.put(player.getUUID(), currentPos);
            } else if (!lastPos.equals((Object)currentPos)) {
                double distance = Math.sqrt(lastPos.distSqr((Vec3i)currentPos));
                player.awardStat(Stats.CUSTOM.get((Object)StatInit.DISTANCE_WALKED), (int)(distance * 100.0));
                lastPathWalkPositions.put(player.getUUID(), currentPos);
                int totalDistance = player.getStats().getValue(Stats.CUSTOM.get((Object)StatInit.DISTANCE_WALKED));
                if ((double)totalDistance >= 500000.0) {
                    SpeedHandler.awardRunningAdvancement(player);
                }
            }
        }
    }

    private static void awardRunningAdvancement(ServerPlayer player) {
        try {
            AdvancementProgress advancementProgress;
            ResourceLocation advancementId = VersionUtils.getLocation("via_romana:story/i_just_felt_like_running");
            AdvancementHolder advancement = player.server.getAdvancements().get(advancementId);
            if (advancement != null && !(advancementProgress = player.getAdvancements().getOrStartProgress(advancement)).isDone()) {
                boolean grantedAny = false;
                for (String criterion : advancementProgress.getRemainingCriteria()) {
                    boolean granted = player.getAdvancements().award(advancement, criterion);
                    if (!granted) continue;
                    grantedAny = true;
                }
                if (grantedAny) {
                    player.getAdvancements().flushDirty(player);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)"via_romana:story/i_just_felt_like_running", (Object)player.getName().getString(), (Object)e.getMessage());
        }
    }
}

