/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.teleport.ServerTeleportHandler;

public record TeleportRequestC2S(BlockPos originSignPos, BlockPos destinationPos) implements AbstractPacket
{
    public TeleportRequestC2S(FriendlyByteBuf buf) {
        this((BlockPos)buf.readNullable(b -> b.readBlockPos()), buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNullable((Object)this.originSignPos, (b, pos) -> b.writeBlockPos(pos));
        buf.writeBlockPos(this.destinationPos);
    }

    public void handle(Level level, Player player) {
        assert (level != null);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerTeleportHandler.handleTeleportRequest(this, serverPlayer);
        }
    }
}

