/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;

public record SignLinkRequestC2S(LinkHandler.LinkData linkData, boolean isTempNode) implements AbstractPacket
{
    public SignLinkRequestC2S(FriendlyByteBuf buf) {
        this(SignLinkRequestC2S.readLinkData(buf), buf.readBoolean());
    }

    private static LinkHandler.LinkData readLinkData(FriendlyByteBuf buf) {
        BlockPos nodePos = buf.readBlockPos();
        BlockPos signPos = buf.readBlockPos();
        Node.LinkType linkType = (Node.LinkType)buf.readEnum(Node.LinkType.class);
        UUID owner = buf.readBoolean() ? buf.readUUID() : null;
        String destinationName = buf.readUtf();
        Node.Icon icon = (Node.Icon)buf.readEnum(Node.Icon.class);
        return new LinkHandler.LinkData(signPos, nodePos, linkType, icon, destinationName, owner);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.linkData.nodePos());
        buf.writeBlockPos(this.linkData.signPos());
        buf.writeEnum((Enum)this.linkData.linkType());
        buf.writeBoolean(this.linkData.owner() != null);
        if (this.linkData.owner() != null) {
            buf.writeUUID(this.linkData.owner());
        }
        buf.writeUtf(this.linkData.destinationName());
        buf.writeEnum((Enum)this.linkData.icon());
        buf.writeBoolean(this.isTempNode);
    }

    public void handle(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean success = LinkHandler.linkSignToNode(serverLevel, this.linkData);
                if (!success) {
                    ViaRomana.LOGGER.warn("Failed to link sign at {} to node at {} for player {}", (Object)this.linkData.signPos(), (Object)this.linkData.nodePos(), (Object)serverPlayer.getName().getString());
                } else if (CommonConfig.logging_enum.ordinal() > 0) {
                    ViaRomana.LOGGER.info("Successfully linked sign at {} to node at {} for player {}", (Object)this.linkData.signPos(), (Object)this.linkData.nodePos(), (Object)serverPlayer.getName().getString());
                }
            }
        }
    }
}

