/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;

public record RoutedActionC2S(Operation op) implements AbstractPacket
{
    public RoutedActionC2S(FriendlyByteBuf buf) {
        this(Operation.values()[buf.readVarInt()]);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.op.ordinal());
    }

    public void handle(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PathGraph graph = PathGraph.getInstance(serverLevel);
                Optional<Node> nearestOpt = graph.getNearestNode(serverPlayer.blockPosition(), CommonConfig.node_utility_distance, node -> true);
                if (nearestOpt.isEmpty()) {
                    ViaRomana.LOGGER.warn("No nearby node found for action {} by player {}", (Object)this.op, (Object)serverPlayer.getName().getString());
                    return;
                }
                Node nearestNode = nearestOpt.get();
                switch (this.op.ordinal()) {
                    case 0: {
                        graph.removeNode(nearestNode);
                        break;
                    }
                    case 1: {
                        graph.removeBranch(nearestNode);
                    }
                }
                PathDataManager.markDirty(serverLevel);
                PathSyncUtils.syncPathGraphToAllPlayers(serverLevel);
            }
        }
    }

    public static enum Operation {
        SEVER_NEAREST_NODE,
        REMOVE_BRANCH;

    }
}

