/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapBaker;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;

public record PreProcessChunksC2S(List<Node.NodeData> tempNodes) implements AbstractPacket
{
    public PreProcessChunksC2S(List<Node.NodeData> tempNodes) {
        this.tempNodes = tempNodes != null ? List.copyOf(tempNodes) : List.of();
    }

    public PreProcessChunksC2S(FriendlyByteBuf buf) {
        this(PreProcessChunksC2S.readNodes(buf));
    }

    private static List<Node.NodeData> readNodes(FriendlyByteBuf buf) {
        int nodeCount = buf.readInt();
        ArrayList<Node.NodeData> nodes = new ArrayList<Node.NodeData>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            BlockPos pos = buf.readBlockPos();
            float quality = buf.readFloat();
            float clearance = buf.readFloat();
            nodes.add(new Node.NodeData(pos, quality, clearance));
        }
        return nodes;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.tempNodes.size());
        for (Node.NodeData nodeData : this.tempNodes) {
            buf.writeBlockPos(nodeData.pos());
            buf.writeFloat(nodeData.quality());
            buf.writeFloat(nodeData.clearance());
        }
    }

    public void handle(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                PathGraph graph;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (this.tempNodes.isEmpty() || this.tempNodes.size() < 2) {
                    return;
                }
                UUID playerUUID = serverPlayer.getUUID();
                UUID pseudoNetworkId = ServerMapCache.getPseudoNetworkId(playerUUID);
                if (CommonConfig.logging_enum.ordinal() > 1) {
                    ViaRomana.LOGGER.info("Creating/updating pseudonetwork {} for player {} with {} temp nodes", (Object)pseudoNetworkId, (Object)serverPlayer.getName().getString(), (Object)this.tempNodes.size());
                }
                if ((graph = PathGraph.getInstance(serverLevel)) == null) {
                    ViaRomana.LOGGER.warn("PathGraph is null, cannot create pseudonetwork");
                    return;
                }
                graph.createOrUpdatePseudoNetwork(pseudoNetworkId, this.tempNodes);
                ServerMapCache.markAsPseudoNetwork(pseudoNetworkId);
                ExecutorService executor = ServerMapCache.getMapBakingExecutor();
                if (executor != null && !executor.isShutdown()) {
                    ((CompletableFuture)MapBaker.bakeAsync(pseudoNetworkId, serverLevel, executor).thenAccept(mapInfo -> {
                        if (mapInfo != null && CommonConfig.logging_enum.ordinal() > 1) {
                            ViaRomana.LOGGER.info("Completed async chunk pre-processing for pseudonetwork {}: {}x{} pixels", (Object)pseudoNetworkId, (Object)mapInfo.pixelWidth(), (Object)mapInfo.pixelHeight());
                        }
                    })).exceptionally(ex -> {
                        ViaRomana.LOGGER.error("Error during async chunk pre-processing for pseudonetwork {}", (Object)pseudoNetworkId, ex);
                        return null;
                    });
                } else {
                    ViaRomana.LOGGER.warn("Map baking executor not available, skipping chunk pre-processing");
                }
            }
        }
    }
}

