/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.MapResponseS2C;

public record MapRequestC2S(MapInfo mapInfo) implements AbstractPacket
{
    public MapRequestC2S(FriendlyByteBuf buf) {
        this(MapInfo.readFromBuffer(buf));
    }

    public void write(FriendlyByteBuf buf) {
        this.mapInfo.writeToBuffer(buf);
    }

    public static MapRequestC2S create(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        return new MapRequestC2S(MapInfo.request(networkId, minBounds, maxBounds, networkNodes));
    }

    public void handle(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                UUID networkId = this.mapInfo.networkId();
                ServerMapCache.generateMapIfNeeded(networkId, serverLevel).thenAccept(mapInfo -> {
                    if (mapInfo != null) {
                        PacketBroadcaster.S2C.sendToPlayer((Packet)new MapResponseS2C((MapInfo)mapInfo), serverPlayer);
                    }
                });
            }
        }
    }
}

