/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.teleport.ServerTeleportHandler;

public record DestinationRequestC2S(BlockPos sourceSignPos) implements AbstractPacket
{
    public DestinationRequestC2S(FriendlyByteBuf buf) {
        this(buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.sourceSignPos);
    }

    public void handle(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PathGraph graph = PathGraph.getInstance(serverLevel);
                Optional<Node> sourceNodeOpt = graph.getNodeBySignPos(this.sourceSignPos);
                if (sourceNodeOpt.isEmpty()) {
                    ViaRomana.LOGGER.warn("Received destination request for unknown sign at {}", (Object)this.sourceSignPos);
                    return;
                }
                Node sourceNode = sourceNodeOpt.get();
                List<Node> destinations = graph.getCachedTeleportDestinationsFor(serverPlayer.getUUID(), sourceNode);
                PathGraph.NetworkCache cache = graph.getNetworkCache(sourceNode);
                List<DestinationResponseS2C.DestinationInfo> destInfos = graph.getNodesAsDestinationInfo(destinations, sourceNode.getBlockPos());
                List<DestinationResponseS2C.NodeNetworkInfo> networkInfos = graph.getNodesAsInfo(cache);
                DestinationResponseS2C response = new DestinationResponseS2C(destInfos, this.sourceSignPos, sourceNode.getBlockPos(), networkInfos, cache.id());
                if (!CommonConfig.direct_warp || destInfos.size() > 1) {
                    PacketBroadcaster.S2C.sendToPlayer((Packet)response, serverPlayer);
                } else if (destInfos.size() == 1) {
                    TeleportRequestC2S packet = new TeleportRequestC2S(this.sourceSignPos, destInfos.get((int)0).position);
                    ServerTeleportHandler.handleTeleportRequest(packet, (ServerPlayer)player);
                }
            }
        }
    }
}

