/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.StatInit;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public record ChartedPathC2S(List<Node.NodeData> chartedNodes) implements AbstractPacket
{
    public ChartedPathC2S(List<Node.NodeData> chartedNodes) {
        this.chartedNodes = chartedNodes != null ? List.copyOf(chartedNodes) : List.of();
    }

    public ChartedPathC2S(FriendlyByteBuf buf) {
        this(ChartedPathC2S.readNodes(buf));
    }

    private static List<Node.NodeData> readNodes(FriendlyByteBuf buf) {
        int nodeCount = buf.readInt();
        ArrayList<Node.NodeData> nodes = new ArrayList<Node.NodeData>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            BlockPos pos = buf.readBlockPos();
            float quality = buf.readFloat();
            float clearance = buf.readFloat();
            nodes.add(new Node.NodeData(pos, quality, clearance));
        }
        return nodes;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.chartedNodes.size());
        for (Node.NodeData nodeData : this.chartedNodes) {
            buf.writeBlockPos(nodeData.pos());
            buf.writeFloat(nodeData.quality());
            buf.writeFloat(nodeData.clearance());
        }
    }

    public void handle(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PathGraph graph = PathGraph.getInstance(serverLevel);
                UUID playerUUID = serverPlayer.getUUID();
                if (this.chartedNodes.isEmpty()) {
                    ViaRomana.LOGGER.warn("Received empty charted path from player {}", (Object)serverPlayer.getName().getString());
                    return;
                }
                try {
                    double totalDistance = 0.0;
                    for (int i = 1; i < this.chartedNodes.size(); ++i) {
                        BlockPos prev = this.chartedNodes.get(i - 1).pos();
                        BlockPos curr = this.chartedNodes.get(i).pos();
                        totalDistance += Math.sqrt(prev.distSqr((Vec3i)curr));
                    }
                    serverPlayer.awardStat(Stats.CUSTOM.get((Object)StatInit.DISTANCE_CHARTED), (int)(totalDistance * 100.0));
                    graph.createConnectedPath(this.chartedNodes);
                    PathDataManager.markDirty(serverLevel);
                    PathSyncUtils.syncPathGraphToAllPlayers(serverLevel);
                    ChartedPathC2S.awardChartingAdvancements(serverPlayer);
                    UUID pseudoNetworkId = ServerMapCache.getPseudoNetworkId(playerUUID);
                    ServerMapCache.invalidatePseudoNetwork(pseudoNetworkId);
                    int totalCharted = serverPlayer.getStats().getValue(Stats.CUSTOM.get((Object)StatInit.DISTANCE_CHARTED));
                    ViaRomana.LOGGER.debug("Created charted path with {} nodes for player {} ({}m charted, {}m total), cleaned up pseudonetwork {}", (Object)this.chartedNodes.size(), (Object)serverPlayer.getName().getString(), (Object)((int)totalDistance), (Object)totalCharted, (Object)pseudoNetworkId);
                }
                catch (Exception e) {
                    ViaRomana.LOGGER.error("Failed to create charted path for player {}: {}", (Object)serverPlayer.getName().getString(), (Object)e.getMessage());
                }
            }
        }
    }

    private static void awardChartingAdvancements(ServerPlayer player) {
        ChartedPathC2S.awardAdvancement(player, "via_romana:story/a_strand_type_game");
        int totalCharted = player.getStats().getValue(Stats.CUSTOM.get((Object)StatInit.DISTANCE_CHARTED));
        if (totalCharted >= 500000) {
            ChartedPathC2S.awardAdvancement(player, "via_romana:story/straight_up_pathing_it");
        }
    }

    private static void awardAdvancement(ServerPlayer player, String advancementId) {
        try {
            AdvancementProgress advancementProgress;
            ResourceLocation id = VersionUtils.getLocation(advancementId);
            AdvancementHolder advancement = player.server.getAdvancements().get(id);
            if (advancement != null && !(advancementProgress = player.getAdvancements().getOrStartProgress(advancement)).isDone()) {
                boolean grantedAny = false;
                for (String criterion : advancementProgress.getRemainingCriteria()) {
                    boolean granted = player.getAdvancements().award(advancement, criterion);
                    if (!granted) continue;
                    grantedAny = true;
                }
                if (grantedAny) {
                    player.getAdvancements().flushDirty(player);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)advancementId, (Object)player.getName().getString(), (Object)e.getMessage());
        }
    }
}

