/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network;

import dev.corgitaco.dataanchor.network.NetworkContainer;
import dev.corgitaco.dataanchor.network.Packet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.util.VersionUtils;

public class PacketRegistrar {
    public static <T extends AbstractPacket> void register(NetworkContainer container, String id, Class<T> clazz, BiConsumer<T, FriendlyByteBuf> writer, Function<FriendlyByteBuf, T> reader, PacketRunner<T> handler) {
        PacketRunner<AbstractPacket> safeHandler = (packet, level, player) -> {
            if (level.isClientSide()) {
                ClientHandler.handleClient(handler, packet, level, player);
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.server.execute(() -> handler.run(packet, level, player));
            }
        };
        ResourceLocation location = VersionUtils.getLocation("via_romana", id);
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(location);
        StreamCodec codec = CustomPacketPayload.codec(writer::accept, reader::apply);
        AbstractPacket.registerType(clazz, type);
        container.registerPacketHandler(new Packet.Handler(clazz, type, codec, (packet, level, player) -> safeHandler.run((AbstractPacket)packet, level, player)));
    }

    @FunctionalInterface
    public static interface PacketRunner<T> {
        public void run(T var1, Level var2, Player var3);
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        private static <T> void handleClient(PacketRunner<T> handler, T packet, Level level, Player player) {
            Minecraft.getInstance().execute(() -> handler.run(packet, level, player));
        }
    }
}

