/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.mixins;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.level.LevelDataManager;
import net.rasanovum.viaromana.tags.TagGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Inject(method={"onBlockStateChange(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")})
    private void onBlockStateChange(BlockPos pos, BlockState oldState, BlockState newState, CallbackInfo ci) {
        ChunkPos chunkPos;
        ServerLevel world;
        if (oldState == newState) {
            return;
        }
        if (oldState.is(TagGenerator.WARP_BLOCK_TAG)) {
            LinkHandler.handleSignDestruction((ServerLevel)this, pos);
        }
        if (!LevelDataManager.isPixelChunkTracked(world = (ServerLevel)this, chunkPos = new ChunkPos(pos))) {
            return;
        }
        LevelChunk levelChunk = world.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
        if (levelChunk == null) {
            return;
        }
        int localX = pos.getX() & 0xF;
        int localZ = pos.getZ() & 0xF;
        int surfaceY = levelChunk.getHeight(Heightmap.Types.MOTION_BLOCKING, localX, localZ);
        if (pos.getY() < surfaceY - 1) {
            return;
        }
        if (oldState.getMapColor((BlockGetter)world, pos).equals(newState.getMapColor((BlockGetter)world, pos))) {
            return;
        }
        if (newState.getCollisionShape((BlockGetter)world, pos).isEmpty() && oldState.getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            return;
        }
        PathGraph graph = PathGraph.getInstance(world);
        if (graph == null) {
            return;
        }
        List<PathGraph.NetworkCache> networks = graph.findNetworksForChunk(chunkPos);
        if (networks.isEmpty()) {
            return;
        }
        ServerMapCache.markChunkDirty(world, chunkPos, networks);
    }
}

