/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.mixins;

import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.rasanovum.viaromana.util.EffectUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class PreventFatigueRemovalMixin {
    @Unique
    private MobEffectInstance viaRomana$storedFatigueEffect = null;

    @Inject(method={"removeEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void viaRomana$preventNonCommandRemoval(Holder<MobEffect> effect, CallbackInfoReturnable<Boolean> cir) {
        Holder<MobEffect> fatigueEffect = EffectUtils.getEffect("travellers_fatigue");
        if (fatigueEffect != null && effect.value() == fatigueEffect.value()) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
                String className = element.getClassName();
                String methodName = element.getMethodName();
                if (!className.contains("command") && !className.contains("Command") && !className.contains("commands") && !className.contains("Commands") && !methodName.contains("command") && !methodName.contains("execute") && !className.contains("net.minecraft.server.commands") && !className.contains("brigadier")) continue;
                return;
            }
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"removeAllEffects"}, at={@At(value="HEAD")})
    private void viaRomana$storeFatigueEffect(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        MobEffectInstance fatigueEffect = self.getEffect(EffectUtils.getEffect("travellers_fatigue"));
        if (fatigueEffect != null) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
                String className = element.getClassName();
                String methodName = element.getMethodName();
                if (!className.contains("command") && !className.contains("Command") && !className.contains("commands") && !className.contains("Commands") && !methodName.contains("command") && !methodName.contains("execute") && !className.contains("net.minecraft.server.commands") && !className.contains("brigadier")) continue;
                return;
            }
            this.viaRomana$storedFatigueEffect = new MobEffectInstance(fatigueEffect.getEffect(), fatigueEffect.getDuration(), fatigueEffect.getAmplifier(), fatigueEffect.isAmbient(), fatigueEffect.isVisible());
        }
    }

    @Inject(method={"removeAllEffects"}, at={@At(value="RETURN")})
    private void viaRomana$restoreTravellerFatigue(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if (((Boolean)cir.getReturnValue()).booleanValue() && this.viaRomana$storedFatigueEffect != null && !self.hasEffect(EffectUtils.getEffect("travellers_fatigue"))) {
            self.addEffect(this.viaRomana$storedFatigueEffect);
            this.viaRomana$storedFatigueEffect = null;
        }
    }
}

