/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.items;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.core.PathRecord;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.OpenChartingScreenS2C;
import net.rasanovum.viaromana.network.packets.RoutedActionC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.VersionUtils;

public class ChartingMap
extends Item {
    static final ResourceLocation CHARTING = VersionUtils.getLocation("minecraft:item.book.page_turn");
    static final ResourceLocation SEVER = VersionUtils.getLocation("minecraft:entity.sheep.shear");

    public ChartingMap(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!CommonConfig.no_gui_charting) {
                if (!player.isCrouching() || !CommonConfig.enable_remote_map_access) {
                    PacketBroadcaster.S2C.sendToPlayer((Packet)new OpenChartingScreenS2C(), serverPlayer);
                    return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
                }
                PathGraph graph = PathGraph.getInstance((ServerLevel)serverPlayer.level());
                if (graph == null) {
                    return InteractionResultHolder.pass((Object)itemStack);
                }
                Optional<Node> nearestNode = graph.getNearestNode(player.blockPosition(), CommonConfig.node_utility_distance * 2);
                if (!nearestNode.isPresent()) return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
                Node node = nearestNode.get();
                PathGraph.NetworkCache networkCache = graph.getNetworkCacheForNode(node);
                List<Node> destinations = graph.getCachedTeleportDestinationsFor(serverPlayer.getUUID(), node);
                List<DestinationResponseS2C.NodeNetworkInfo> networkInfos = graph.getNodesAsInfo(networkCache);
                DestinationResponseS2C responsePacket = new DestinationResponseS2C(graph.getNodesAsDestinationInfo(destinations, node.getBlockPos()), null, node.getBlockPos(), networkInfos, networkCache.id());
                PacketBroadcaster.S2C.sendToPlayer((Packet)responsePacket, serverPlayer);
                return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
            }
        }
        if (!(player instanceof LocalPlayer)) return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
        LocalPlayer localPlayer = (LocalPlayer)player;
        if (!CommonConfig.no_gui_charting) return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
        SoundEvent clickSound = SoundEvent.createVariableRangeEvent((ResourceLocation)CHARTING);
        if (!PlayerData.isChartingPath(player)) {
            if (!player.isCrouching()) {
                PathRecord.start((ClientLevel)localPlayer.level(), localPlayer, localPlayer.blockPosition());
            } else {
                PacketBroadcaster.C2S.sendToServer((Packet)new RoutedActionC2S(RoutedActionC2S.Operation.SEVER_NEAREST_NODE));
                clickSound = SoundEvent.createVariableRangeEvent((ResourceLocation)SEVER);
            }
        } else if (!player.isCrouching()) {
            PathRecord.end((ClientLevel)localPlayer.level(), localPlayer, localPlayer.blockPosition());
        } else {
            PathRecord.cancel((ClientLevel)localPlayer.level(), localPlayer, true);
        }
        player.playSound(clickSound, 1.0f, 1.0f);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }
}

