/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.packets.DestinationRequestC2S;

public class SignInteract {
    private static BlockPos lastClickedPos = null;
    private static long lastClickTime = 0L;
    private static final long CLICK_DEBOUNCE_MS = 100L;

    public static boolean clicked(LevelAccessor world, BlockPos blockPos, Entity entity) {
        if (entity == null) {
            return false;
        }
        if (LinkHandler.isSignBlock(world, blockPos) && LinkHandler.isSignLinked(world, blockPos) && !entity.isShiftKeyDown()) {
            long currentTime = System.currentTimeMillis();
            if (blockPos.equals((Object)lastClickedPos) && currentTime - lastClickTime < 100L) {
                return true;
            }
            lastClickedPos = blockPos.immutable();
            lastClickTime = currentTime;
            if (world.isClientSide() && entity instanceof Player) {
                DestinationRequestC2S req = new DestinationRequestC2S(blockPos);
                PacketBroadcaster.C2S.sendToServer((Packet)req);
                return true;
            }
        }
        return false;
    }
}

