/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.FadeManager;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.LinkedSignToast;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class LinkIndicationHandler {
    private static int tickCounter = 0;
    private static final int SCAN_INTERVAL = 10;
    private static final double RENDER_RADIUS = 12.0;
    private static final RandomSource RANDOM = RandomSource.create();
    private static final List<BlockPos> CACHED_SIGNS = new ArrayList<BlockPos>();
    private static final Component TOOLTIP_TEXT = Component.translatable((String)"gui.viaromana.left_click_hover_tip");
    private static final ResourceLocation CURSOR = VersionUtils.getLocation("via_romana:textures/screens/cursor.png");
    private static final int ICON_SIZE = 18;
    private static float currentOpacity = 0.0f;
    private static final float fadeSpeed = 0.25f;
    private static boolean isHovering = false;
    static final double driftRange = 0.5;

    public static void onClientTick() {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null || client.player == null || client.isPaused()) {
            return;
        }
        if (CommonConfig.enable_custom_cursor) {
            LinkIndicationHandler.handleLookTarget(client);
            LinkIndicationHandler.updateOpacity();
            if (isHovering && client.player != null && !PlayerData.hasSeenLinkedSignToast((Player)client.player)) {
                client.getToasts().addToast((Toast)new LinkedSignToast((Component)Component.translatable((String)"toast.viaromana.linked_sign_hint.title"), (Component)Component.translatable((String)"toast.viaromana.linked_sign_hint.description")));
                PlayerData.setSeenLinkedSignToast((Player)client.player, true);
            }
        } else {
            currentOpacity = 0.0f;
            isHovering = false;
        }
        if (++tickCounter % 10 != 0) {
            return;
        }
        LinkIndicationHandler.updateCacheAndSpawnParticles(client);
    }

    public static float getCrosshairAlpha() {
        if (!CommonConfig.enable_custom_cursor) {
            return 1.0f;
        }
        float globalFade = 1.0f - FadeManager.getCurrentFadeAlpha();
        return (1.0f - currentOpacity) * globalFade;
    }

    public static void render(GuiGraphics graphics, float tickDelta) {
        if (currentOpacity <= 0.05f) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui) {
            return;
        }
        int width = mc.getWindow().getGuiScaledWidth();
        int height = mc.getWindow().getGuiScaledHeight();
        float alpha = Mth.clamp((float)currentOpacity, (float)0.0f, (float)1.0f);
        float globalFade = 1.0f - FadeManager.getCurrentFadeAlpha();
        if ((alpha *= globalFade) <= 0.01f) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        graphics.blit(CURSOR, (width - 18) / 2, (height - 18) / 2, 0.0f, 0.0f, 18, 18, 18, 18);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    private static void updateOpacity() {
        if (isHovering) {
            if ((currentOpacity += 0.25f) > 1.0f) {
                currentOpacity = 1.0f;
            }
        } else if ((currentOpacity -= 0.25f) < 0.0f) {
            currentOpacity = 0.0f;
        }
    }

    private static void handleLookTarget(Minecraft mc) {
        BlockPos hitPos;
        isHovering = false;
        if (Objects.requireNonNull(mc.player).isCrouching()) {
            return;
        }
        if (mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK && CACHED_SIGNS.contains(hitPos = ((BlockHitResult)mc.hitResult).getBlockPos())) {
            isHovering = true;
        }
    }

    private static void updateCacheAndSpawnParticles(Minecraft client) {
        CACHED_SIGNS.clear();
        assert (client.player != null);
        BlockPos playerPos = client.player.blockPosition();
        List<Node> nearbyNodes = ClientPathData.getInstance().getNearbyNodes(playerPos, 12.0, false);
        for (Node node : nearbyNodes) {
            if (!node.isLinked()) continue;
            node.getSignPos().ifPresent(signPosLong -> {
                BlockPos signPos = BlockPos.of((long)signPosLong);
                if (signPos.distSqr((Vec3i)playerPos) <= 144.0) {
                    CACHED_SIGNS.add(signPos);
                    LinkIndicationHandler.spawnLinkParticles((Level)client.level, signPos);
                }
            });
        }
    }

    private static void spawnLinkParticles(Level level, BlockPos pos) {
        if (!CommonConfig.enable_sign_particles) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            double startX = (double)pos.getX() + 0.5 + (RANDOM.nextDouble() - 0.5) * 1.5;
            double startY = (double)pos.getY() + 0.5 + RANDOM.nextDouble() * 0.8;
            double startZ = (double)pos.getZ() + 0.5 + (RANDOM.nextDouble() - 0.5) * 1.5;
            double endX = startX + (RANDOM.nextDouble() - 0.5) * 0.5;
            double endZ = startZ + (RANDOM.nextDouble() - 0.5) * 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, endX, startY, endZ, startX - endX, 0.0, startZ - endZ);
        }
    }
}

