/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.ClientConfigCache;
import net.rasanovum.viaromana.items.ChartingMap;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class InvalidBlockRenderer {
    private static final ResourceLocation BARRIER_TEXTURE = VersionUtils.getLocation("minecraft:textures/item/barrier.png");

    private static float getAlpha() {
        return CommonConfig.invalid_block_overlay_opacity;
    }

    private static int getRadius() {
        return ClientConfigCache.infrastructureCheckRadius;
    }

    public static void renderInfrastructureBlocks(PoseStack poseStack, Level level, Player player, float tickDelta) {
        boolean shouldRender;
        boolean bl = shouldRender = InvalidBlockRenderer.getAlpha() > 0.0f && (PlayerData.isChartingPath(player) || player.getMainHandItem().getItem() instanceof ChartingMap || player.getOffhandItem().getItem() instanceof ChartingMap);
        if (!shouldRender) {
            return;
        }
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)BARRIER_TEXTURE));
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        BlockPos centerPos = player.blockPosition();
        int radius = InvalidBlockRenderer.getRadius();
        float baseAlpha = InvalidBlockRenderer.getAlpha();
        double maxDistance = Math.sqrt(3.0) * (double)radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    VoxelShape currentShape;
                    BlockPos blockAbove;
                    BlockState blockStateAbove;
                    BlockPos pos = centerPos.offset(x, y, z);
                    BlockState state = level.getBlockState(pos);
                    if (state.isAir() || !(blockStateAbove = level.getBlockState(blockAbove = pos.above())).isAir() && blockStateAbove.isCollisionShapeFullBlock((BlockGetter)level, blockAbove) || (currentShape = state.getCollisionShape((BlockGetter)level, pos)).isEmpty() || PathUtils.isBlockValidPath((LevelAccessor)level, pos)) continue;
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    float fadeFactor = 1.0f - (float)(distance / maxDistance) * 0.75f;
                    float alpha = baseAlpha * fadeFactor;
                    float topY = (float)currentShape.bounds().maxY;
                    poseStack.pushPose();
                    poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                    PoseStack.Pose blockPose = poseStack.last();
                    InvalidBlockRenderer.renderTopFace(blockPose, consumer, 0.0f, 1.0f, topY, 0.0f, 1.0f, alpha);
                    poseStack.popPose();
                }
            }
        }
        poseStack.popPose();
        bufferSource.endBatch(RenderType.entityTranslucentCull((ResourceLocation)BARRIER_TEXTURE));
    }

    private static void renderTopFace(PoseStack.Pose pose, VertexConsumer consumer, float minX, float maxX, float y, float minZ, float maxZ, float alpha) {
        int light = 0xF000F0;
        int overlay = 655360;
        float yOffset = y + 0.06f;
        int color = (int)(alpha * 255.0f) << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        consumer.addVertex(pose, minX, yOffset, minZ).setColor(color).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, minX, yOffset, maxZ).setColor(color).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, maxX, yOffset, maxZ).setColor(color).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, maxX, yOffset, minZ).setColor(color).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
    }
}

