/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.core;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.client.core.ChartingHandler;
import net.rasanovum.viaromana.core.DimensionHandler;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathUtils;

public class PathRecord {
    public static void start(ClientLevel world, LocalPlayer player, BlockPos playerPos) {
        if (player == null) {
            return;
        }
        if (!DimensionHandler.isValid((LevelAccessor)world, (Entity)player)) {
            return;
        }
        float infrastructureQuality = PathUtils.calculateInfrastructureQuality((LevelAccessor)world, (Entity)player);
        float clearance = PathUtils.calculateClearance((LevelAccessor)world, (Entity)player);
        ChartingHandler.initializeChartingNodes(player);
        ChartingHandler.addChartingNode((LevelAccessor)world, (Entity)player, playerPos, Float.valueOf(infrastructureQuality), Float.valueOf(clearance));
        PlayerData.setChartingPath((Player)player, true);
    }

    public static void end(ClientLevel world, LocalPlayer player, BlockPos playerPos) {
        if (player == null) {
            return;
        }
        ChartingHandler.finishPath(player);
        ChartingHandler.initializeChartingNodes(player);
        PlayerData.resetVariables((Player)player);
    }

    public static void cancel(ClientLevel world, LocalPlayer player, boolean showMessage) {
        if (player == null) {
            return;
        }
        if (showMessage) {
            HudMessageManager.queueMessage("message.via_romana.cancel_charting");
        }
        ChartingHandler.initializeChartingNodes(player);
        PlayerData.resetVariables((Player)player);
    }
}

