/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.core;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.client.ClientConfigCache;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.packets.ChartedPathC2S;
import net.rasanovum.viaromana.network.packets.PreProcessChunksC2S;
import net.rasanovum.viaromana.network.packets.SignLinkRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public final class ChartingHandler {
    private static final int PREPROCESS_INTERVAL = 5;

    public static void chartPath(LevelAccessor level, Entity entity) {
        if (!PlayerData.isChartingPath((Player)entity)) {
            return;
        }
        float nodeDistance = PathUtils.calculateNodeDistance(entity);
        float infrastructureQuality = PathUtils.calculateInfrastructureQuality(level, entity);
        float clearance = PathUtils.calculateClearance(level, entity);
        if (nodeDistance > (float)ClientConfigCache.nodeDistanceMaximum) {
            HudMessageManager.queueMessage("message.via_romana.too_far_from_node_message");
            return;
        }
        if (infrastructureQuality < ClientConfigCache.pathQualityThreshold) {
            float threshold = ClientConfigCache.pathQualityThreshold;
            int areaCheck = ClientConfigCache.infrastructureCheckRadius * 2 + 1;
            areaCheck *= areaCheck;
            int requiredBlocks = (int)Math.ceil(threshold * (float)areaCheck);
            int currentBlocks = Math.round(infrastructureQuality * (float)areaCheck);
            HudMessageManager.queueMessage((Component)Component.translatable((String)"gui.viaromana.infrastructure_insufficient", (Object[])new Object[]{currentBlocks, requiredBlocks}));
            return;
        }
        if (nodeDistance < (float)ClientConfigCache.nodeDistanceMinimum) {
            HudMessageManager.queueMessage("message.via_romana.path_charting");
            return;
        }
        ChartingHandler.addChartingNode(level, entity, entity.blockPosition(), Float.valueOf(infrastructureQuality), Float.valueOf(clearance));
    }

    private static void playCartographySound(LevelAccessor level, Player player) {
        if (!(level instanceof Level)) {
            return;
        }
        Level lvl = (Level)level;
        BlockPos pos = BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ());
        SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(VersionUtils.getLocation("minecraft:ui.cartography_table.take_result"));
        assert (sound != null);
        if (lvl.isClientSide()) {
            lvl.playLocalSound(player.getX(), player.getY(), player.getZ(), sound, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        } else {
            lvl.playSound(null, pos, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void addChartingNode(LevelAccessor level, Entity entity, BlockPos pos, Float quality, Float clearance) {
        Optional<Node> nearbyNode;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (Math.random() > 0.9) {
            ChartingHandler.playCartographySound(level, player);
        }
        if ((nearbyNode = ClientPathData.getInstance().getNearestNode(pos, ClientConfigCache.nodeUtilityDistance, 1.0, true)).isPresent()) {
            pos = nearbyNode.get().getBlockPos();
            quality = Float.valueOf(nearbyNode.get().getQuality());
            clearance = Float.valueOf(nearbyNode.get().getClearance());
        }
        PlayerData.setLastNodePos(player, pos, false);
        ClientPathData.getInstance().addTemporaryNode(pos, quality.floatValue(), clearance.floatValue());
        List<Node.NodeData> tempNodes = ClientPathData.getInstance().getTemporaryNodes();
        if (tempNodes.size() % 5 == 0 && tempNodes.size() >= 2) {
            PreProcessChunksC2S packet = new PreProcessChunksC2S(tempNodes);
            PacketBroadcaster.C2S.sendToServer((Packet)packet);
        }
    }

    public static void finishPath(LocalPlayer player) {
        ClientPathData clientPathData = ClientPathData.getInstance();
        List<Node.NodeData> chartingNodes = clientPathData.getTemporaryNodes();
        List<LinkHandler.LinkData> chartingLinks = clientPathData.getTemporaryLinks();
        if (player == null || chartingNodes == null || chartingNodes.isEmpty()) {
            return;
        }
        ChartedPathC2S packet = new ChartedPathC2S(chartingNodes);
        PacketBroadcaster.C2S.sendToServer((Packet)packet);
        if (chartingLinks != null && !chartingLinks.isEmpty()) {
            for (LinkHandler.LinkData link : chartingLinks) {
                SignLinkRequestC2S linkPacket = new SignLinkRequestC2S(link, false);
                PacketBroadcaster.C2S.sendToServer((Packet)linkPacket);
            }
        }
        HudMessageManager.queueMessage("message.via_romana.finish_charting");
    }

    public static void initializeChartingNodes(LocalPlayer player) {
        if (player != null) {
            ClientPathData.getInstance().clearTemporaryNodes();
        }
    }
}

