/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.mixin;

import com.mojang.brigadier.suggestion.Suggestion;
import dev.norbiros.emojitype.EmojiType;
import dev.norbiros.emojitype.emoji.EmojiCode;
import dev.norbiros.emojitype.mixin.ChatInputSuggestorAccessor;
import java.util.List;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommandSuggestions.SuggestionsList.class})
public abstract class SuggestionWindowMixin {
    @Shadow
    @Final
    CommandSuggestions this$0;
    @Shadow
    private int current;
    @Shadow
    @Final
    private List<Suggestion> suggestionList;

    @Inject(method={"useSuggestion()V"}, at={@At(value="TAIL")})
    private void overwriteComplete(CallbackInfo ci) {
        ChatInputSuggestorAccessor inputSuggestor = (ChatInputSuggestorAccessor)this.this$0;
        if (inputSuggestor == null) {
            return;
        }
        EditBox textFieldWidget = inputSuggestor.getInput();
        Suggestion suggestion = this.suggestionList.get(this.current);
        int just = suggestion.getRange().getStart() + suggestion.getText().length() - 2;
        for (EmojiCode ec : EmojiType.emojiCodes) {
            int justTyped = just - ec.getEmoji().length();
            if (!ec.match(textFieldWidget.getValue(), justTyped)) continue;
            textFieldWidget.deleteChars(-ec.getCode().length() - (1 + ec.getEmoji().length()));
            textFieldWidget.setHighlightPos(textFieldWidget.getCursorPosition());
            textFieldWidget.insertText(ec.getEmoji());
            break;
        }
    }
}

