/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.config;

import dev.norbiros.emojitype.emoji.EmojiCode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;

public class EmojiListWidget
extends ContainerObjectSelectionList<EmojiWidgetEntry> {
    public EmojiListWidget(Minecraft client, int width, int height, int top, int itemHeight) {
        super(client, width, height, top, itemHeight);
    }

    public void addEntry(EmojiCode emoji) {
        this.addEntry((AbstractSelectionList.Entry)new EmojiWidgetEntry(this.width, emoji, this));
    }

    public void addEntryAfter(EmojiCode emoji, EmojiWidgetEntry element) {
        int index = this.children().indexOf((Object)element);
        this.children().add(index + 1, new EmojiWidgetEntry(this.width, emoji, this));
    }

    public List<String> getCurrentCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        for (EmojiWidgetEntry entry : this.children()) {
            codes.add(entry.getEmojiCode().toString());
        }
        return codes;
    }

    public int getRowWidth() {
        return this.width - 40;
    }

    protected int getScrollbarPosition() {
        return this.width - 12;
    }

    public static class EmojiWidgetEntry
    extends ContainerObjectSelectionList.Entry<EmojiWidgetEntry> {
        private final EmojiListWidget parent;
        List<AbstractWidget> elements = new ArrayList<AbstractWidget>();

        public EmojiWidgetEntry(int entryWidth, EmojiCode emoji, EmojiListWidget parent) {
            this.parent = parent;
            Minecraft client = Minecraft.getInstance();
            MultiLineEditBox editBoxWidgetEmoji = new MultiLineEditBox(client.font, entryWidth / 2 - 200, 0, 110, 18, (Component)Component.empty(), (Component)Component.empty());
            editBoxWidgetEmoji.setValue(emoji.getEmoji());
            this.elements.add((AbstractWidget)editBoxWidgetEmoji);
            MultiLineEditBox editBoxWidgetCode = new MultiLineEditBox(client.font, entryWidth / 2 - 85, 0, 235, 18, (Component)Component.empty(), (Component)Component.empty());
            String emojiCode = emoji.getCode();
            editBoxWidgetCode.setValue(emojiCode.substring(1, emojiCode.length() - 1));
            this.elements.add((AbstractWidget)editBoxWidgetCode);
            this.elements.add((AbstractWidget)Button.builder((Component)Component.literal((String)"\u2795"), button -> this.parent.addEntryAfter(EmojiCode.EMPTY, this)).bounds(entryWidth / 2 + 157, 0, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"config.emojitype.add_entry_below_tooltip"))).build());
            this.elements.add((AbstractWidget)Button.builder((Component)Component.literal((String)"\u274c"), button -> this.parent.removeEntry((AbstractSelectionList.Entry)this)).bounds(entryWidth / 2 + 180, 0, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"config.emojitype.remove_entry_tooltip"))).build());
        }

        public EmojiCode getEmojiCode() {
            MultiLineEditBox emoji = (MultiLineEditBox)this.elements.get(0);
            MultiLineEditBox key = (MultiLineEditBox)this.elements.get(1);
            return new EmojiCode(":" + key.getValue() + ":", emoji.getValue());
        }

        public List<? extends GuiEventListener> children() {
            return this.elements;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.elements;
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            for (AbstractWidget element : this.elements) {
                if (element instanceof Button) {
                    element.setY(y - 1);
                } else {
                    element.setY(y);
                }
                element.render(context, mouseX, mouseY, tickDelta);
            }
        }
    }
}

