/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.item;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.meadow.core.recipes.FeltingRecipe;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import org.jetbrains.annotations.NotNull;

public class FeltingNeedleItem
extends Item {
    private static final int USE_DURATION = 120;
    private static final String FELTING_KEY = "Felting";

    public FeltingNeedleItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 120;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        ItemStack needle = player.getMainHandItem();
        ItemStack input = player.getOffhandItem();
        if (!this.canFelt(level, input)) {
            return InteractionResultHolder.fail((Object)needle);
        }
        ItemStack inputCopy = input.copy();
        ItemStack toFelt = inputCopy.split(1);
        CompoundTag root = FeltingNeedleItem.getOrCreateCustomData(needle);
        DataResult enc = ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)toFelt);
        Tag tag = enc.result().orElseGet(CompoundTag::new);
        if (tag instanceof CompoundTag) {
            CompoundTag ct = (CompoundTag)tag;
            root.put(FELTING_KEY, (Tag)ct);
            FeltingNeedleItem.setCustomData(needle, root);
        }
        player.setItemInHand(InteractionHand.OFF_HAND, inputCopy);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)needle);
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!(user instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)user;
        CompoundTag root = FeltingNeedleItem.getCustomData(stack);
        if (root != null && root.contains(FELTING_KEY)) {
            CompoundTag stored = root.getCompound(FELTING_KEY);
            Optional inputOpt = ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)stored).result();
            if (inputOpt.isPresent()) {
                ItemStack input = (ItemStack)inputOpt.get();
                Optional<ItemStack> result = this.getFeltingResult(level, input);
                if (result.isPresent() && !result.get().isEmpty()) {
                    ItemStack out = result.get();
                    player.getInventory().placeItemBackInInventory(out);
                    this.spawnParticles(user.position(), out, level);
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                } else {
                    player.getInventory().placeItemBackInInventory(input);
                }
            }
            root.remove(FELTING_KEY);
            if (root.isEmpty()) {
                FeltingNeedleItem.removeCustomData(stack);
            } else {
                FeltingNeedleItem.setCustomData(stack, root);
            }
        }
        return stack;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag root = FeltingNeedleItem.getCustomData(stack);
        if (root != null && root.contains(FELTING_KEY)) {
            CompoundTag stored = root.getCompound(FELTING_KEY);
            Optional inputOpt = ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)stored).result();
            inputOpt.ifPresent(s -> player.getInventory().placeItemBackInInventory(s));
            root.remove(FELTING_KEY);
            if (root.isEmpty()) {
                FeltingNeedleItem.removeCustomData(stack);
            } else {
                FeltingNeedleItem.setCustomData(stack, root);
            }
        }
    }

    private Optional<ItemStack> getFeltingResult(Level level, ItemStack input) {
        SingleRecipeInput in = new SingleRecipeInput(input);
        return level.getRecipeManager().getRecipeFor((RecipeType)RecipeRegistry.FELTING.get(), (RecipeInput)in, level).map(h -> ((FeltingRecipe)h.value()).assemble((RecipeInput)in, (HolderLookup.Provider)level.registryAccess())).filter(s -> !s.isEmpty());
    }

    private boolean canFelt(Level level, ItemStack input) {
        return this.getFeltingResult(level, input).isPresent();
    }

    private void spawnParticles(Vec3 pos, ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return;
        }
        for (int i = 0; i < 15; ++i) {
            Vec3 m = new Vec3((level.random.nextDouble() - 0.5) * 0.2, (level.random.nextDouble() - 0.5) * 0.2, (level.random.nextDouble() - 0.5) * 0.2);
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y + 1.0, pos.z, m.x, m.y, m.z);
        }
    }

    private static CompoundTag getCustomData(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return data == null ? null : data.copyTag();
    }

    private static CompoundTag getOrCreateCustomData(ItemStack stack) {
        CompoundTag tag = FeltingNeedleItem.getCustomData(stack);
        return tag == null ? new CompoundTag() : tag;
    }

    private static void setCustomData(ItemStack stack, CompoundTag tag) {
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    private static void removeCustomData(ItemStack stack) {
        stack.remove(DataComponents.CUSTOM_DATA);
    }
}

