/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.meadow.client.gui.handler.CheeseFormGuiHandler;
import net.satisfy.meadow.core.block.CheeseFormBlock;
import net.satisfy.meadow.core.recipes.CheeseFormRecipe;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import net.satisfy.meadow.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheeseFormBlockEntity
extends BlockEntity
implements BlockEntityTicker<CheeseFormBlockEntity>,
MenuProvider,
ImplementedInventory {
    private NonNullList<ItemStack> inventory;
    public static final int CAPACITY = 3;
    public static final int COOKING_TIME_IN_TICKS = 1800;
    private static final int OUTPUT_SLOT = 0;
    private int fermentationTime = 0;
    protected float experience;
    private static final int[] SLOTS_FOR_SIDE = new int[]{2};
    private static final int[] SLOTS_FOR_UP = new int[]{1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0};
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            if (index == 0) {
                return CheeseFormBlockEntity.this.fermentationTime;
            }
            if (index == 1) {
                return 1800;
            }
            return 0;
        }

        public void set(int index, int value) {
            if (index == 0) {
                CheeseFormBlockEntity.this.fermentationTime = value;
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public CheeseFormBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.CHEESE_FORM_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    }

    @Override
    public int @NotNull [] getSlotsForFace(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        this.fermentationTime = compoundTag.getShort("fermentationTime");
        this.experience = compoundTag.getFloat("experience");
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        compoundTag.putShort("fermentationTime", (short)this.fermentationTime);
        compoundTag.putFloat("experience", this.experience);
    }

    public void tick(Level world, BlockPos pos, BlockState state, CheeseFormBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        RecipeManager recipeManager = world.getRecipeManager();
        List recipes = recipeManager.getAllRecipesFor((RecipeType)RecipeRegistry.CHEESE.get());
        Optional<CheeseFormRecipe> recipe = Optional.ofNullable(this.getRecipe(recipes, this.inventory));
        if (recipe.isPresent()) {
            boolean done;
            RegistryAccess access = world.registryAccess();
            boolean working = this.canCraft(recipe.get(), access);
            if (working) {
                ++this.fermentationTime;
                if (this.fermentationTime >= 1800) {
                    this.fermentationTime = 0;
                    this.craft(recipe.get(), access);
                    this.setChanged();
                }
            } else {
                this.fermentationTime = 0;
            }
            boolean bl = done = !((ItemStack)this.inventory.getFirst()).isEmpty();
            if ((Boolean)state.getValue((Property)CheeseFormBlock.WORKING) != working || (Boolean)state.getValue((Property)CheeseFormBlock.DONE) != done) {
                world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)CheeseFormBlock.WORKING, (Comparable)Boolean.valueOf(working))).setValue((Property)CheeseFormBlock.DONE, (Comparable)Boolean.valueOf(done)));
            }
        }
    }

    private CheeseFormRecipe getRecipe(List<RecipeHolder<CheeseFormRecipe>> recipes, NonNullList<ItemStack> inventory) {
        block0: for (RecipeHolder<CheeseFormRecipe> recipeHolder : recipes) {
            CheeseFormRecipe recipe = (CheeseFormRecipe)recipeHolder.value();
            for (Ingredient ingredient : recipe.getIngredients()) {
                boolean ingredientFound = false;
                for (int slotIndex = 1; slotIndex < inventory.size(); ++slotIndex) {
                    ItemStack slotItem = (ItemStack)inventory.get(slotIndex);
                    if (!ingredient.test(slotItem)) continue;
                    ingredientFound = true;
                    break;
                }
                if (ingredientFound) continue;
                continue block0;
            }
            return recipe;
        }
        return null;
    }

    private boolean canCraft(CheeseFormRecipe recipe, RegistryAccess manager) {
        if (recipe == null || recipe.getResultItem((HolderLookup.Provider)manager).isEmpty()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        ItemStack itemStack = this.getItem(0);
        return itemStack.isEmpty() || itemStack.is(recipe.getResultItem((HolderLookup.Provider)manager).getItem());
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i <= 2; ++i) {
            if (!this.getItem(i).isEmpty()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 2;
    }

    private void craft(CheeseFormRecipe recipe, RegistryAccess manager) {
        if (!this.canCraft(recipe, manager)) {
            return;
        }
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)manager);
        ItemStack outputSlotStack = this.getItem(0);
        if (outputSlotStack.isEmpty()) {
            ItemStack output = recipeOutput.copy();
            this.setItem(0, output);
        } else if (outputSlotStack.is(recipeOutput.getItem())) {
            outputSlotStack.grow(recipeOutput.getCount());
        }
        ItemStack slot1Stack = this.getItem(1);
        if (recipe.getIngredients().stream().anyMatch(entry -> entry.test(slot1Stack))) {
            if (slot1Stack.is(TagRegistry.MILK_BUCKET)) {
                this.setItem(1, Items.BUCKET.getDefaultInstance());
            } else if (slot1Stack.is(TagRegistry.WOODEN_MILK_BUCKET)) {
                this.setItem(1, ((Item)ObjectRegistry.WOODEN_BUCKET.get()).getDefaultInstance());
            } else {
                this.removeItem(1, 1);
            }
        }
        ItemStack slot2Stack = this.getItem(2);
        if (recipe.getIngredients().stream().anyMatch(entry -> entry.test(slot2Stack))) {
            if (slot2Stack.is(TagRegistry.MILK_BUCKET)) {
                this.setItem(2, Items.BUCKET.getDefaultInstance());
            } else if (slot2Stack.is(TagRegistry.WOODEN_MILK_BUCKET)) {
                this.setItem(2, ((Item)ObjectRegistry.WOODEN_BUCKET.get()).getDefaultInstance());
            } else if (slot2Stack.is(TagRegistry.MILK)) {
                ItemStack bucket = slot2Stack.getItem() == ObjectRegistry.WOODEN_MILK_BUCKET.get() ? ((Item)ObjectRegistry.WOODEN_BUCKET.get()).getDefaultInstance() : Items.BUCKET.getDefaultInstance();
                this.setItem(2, bucket);
            } else {
                this.removeItem(2, 1);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.matches((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (!(slot != 1 && slot != 2 || dirty)) {
            this.fermentationTime = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean stillValid(Player player) {
        assert (this.level != null);
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public Component getDisplayName() {
        return ((Block)ObjectRegistry.CHEESE_FORM.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new CheeseFormGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }
}

