/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class OilLantern
extends LanternBlock {
    protected static final VoxelShape STANDING_SHAPE = OilLantern.createStandingLanternShape();

    public static VoxelShape createHangingLanternShape() {
        VoxelShape baseShape = Shapes.empty();
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.6875, (double)0.625), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.25, (double)0.3125, (double)0.5, (double)0.3125, (double)0.75, (double)0.5), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.6875, (double)0.3125, (double)0.5, (double)0.75, (double)0.75, (double)0.5), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.5, (double)0.3125, (double)0.6875, (double)0.5, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.5, (double)0.3125, (double)0.25, (double)0.5, (double)0.75, (double)0.3125), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.3125, (double)0.1875, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.3125, (double)0.6875, (double)0.3125, (double)0.6875, (double)0.8125, (double)0.6875), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.375, (double)0.8125, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        return baseShape;
    }

    public static VoxelShape createStandingLanternShape() {
        VoxelShape baseShape = Shapes.empty();
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0625, (double)0.5, (double)0.3125, (double)0.5625, (double)0.5), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.5, (double)0.0625, (double)0.6875, (double)0.5, (double)0.5625, (double)0.8125), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.1875, (double)0.6875), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.375, (double)0.1875, (double)0.375, (double)0.625, (double)0.5, (double)0.625), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.3125, (double)0.5, (double)0.3125, (double)0.6875, (double)0.625, (double)0.6875), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.5, (double)0.0625, (double)0.1875, (double)0.5, (double)0.5625, (double)0.3125), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0625, (double)0.5, (double)0.8125, (double)0.5625, (double)0.5), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.375, (double)0.625, (double)0.375, (double)0.625, (double)0.6875, (double)0.625), (BooleanOp)BooleanOp.OR);
        baseShape = Shapes.joinUnoptimized((VoxelShape)baseShape, (VoxelShape)Shapes.box((double)0.40625, (double)0.6875, (double)0.40625, (double)0.59375, (double)0.8125, (double)0.59375), (BooleanOp)BooleanOp.OR);
        return baseShape;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double d = (double)pos.getX() + 0.5;
        double e = (double)pos.getY() + 0.7;
        double f = (double)pos.getZ() + 0.5;
        if (random.nextDouble() < 0.3) {
            world.playLocalSound(d, e, f, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 2.0f, 1.0f, false);
        }
        double h = random.nextDouble() * 0.6 - 0.3;
        double i = random.nextDouble() * 9.0 / 16.0;
        double j = random.nextDouble() * 0.6 - 0.3;
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d + h, e + i, f + j, 0.0, 0.0, 0.0);
    }

    public OilLantern(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? OilLantern.createHangingLanternShape() : STANDING_SHAPE;
    }
}

