/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.FacingBlock;
import org.jetbrains.annotations.NotNull;

public class CheeseBlock
extends FacingBlock {
    private static final VoxelShape SHAPE_GRAIN = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0);
    private static final VoxelShape SHAPE_CHEESE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape SHAPE_WARPED = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
    private static final VoxelShape SHAPE_BUFFALO = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private static final VoxelShape SHAPE_SHEEP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    private static final VoxelShape SHAPE_CAKE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    public static final IntegerProperty CUTS = IntegerProperty.create((String)"cuts", (int)0, (int)3);
    private final RegistrySupplier<Item> slice;
    private final CheeseType cheeseType;

    public CheeseBlock(BlockBehaviour.Properties settings, RegistrySupplier<Item> slice, CheeseType cheeseType) {
        super(settings);
        this.slice = slice;
        this.cheeseType = cheeseType;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CUTS});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch (this.cheeseType.ordinal()) {
            case 0 -> SHAPE_GRAIN;
            case 2 -> SHAPE_WARPED;
            case 3, 4 -> SHAPE_BUFFALO;
            case 5 -> SHAPE_SHEEP;
            case 6 -> SHAPE_CAKE;
            default -> SHAPE_CHEESE;
        };
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        InteractionHand hand = player.getUsedItemHand();
        ItemStack itemStack = player.getItemInHand(hand);
        if (world.isClientSide) {
            if (this.tryEat((LevelAccessor)world, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (itemStack.isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.tryEat((LevelAccessor)world, pos, state, player);
    }

    private InteractionResult tryEat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        world.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
        CheeseBlock.popResourceFromFace((Level)((Level)world), (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)this.slice.get()));
        int i = (Integer)state.getValue((Property)CUTS);
        world.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (i < 3) {
            world.setBlock(pos, (BlockState)state.setValue((Property)CUTS, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.removeBlock(pos, false);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isSolid();
    }

    public static enum CheeseType {
        GRAIN,
        REGULAR,
        WARPED,
        BUFFALO,
        GOAT,
        SHEEP,
        CAKE;

    }
}

