/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.ScreenHandlerRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public class CookingCauldronGuiHandler
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData propertyDelegate;

    public CookingCauldronGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(4));
    }

    public CookingCauldronGuiHandler(int syncId, Inventory playerInventory, Container container, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get(), syncId);
        int i;
        this.container = container;
        this.propertyDelegate = propertyDelegate;
        this.addDataSlots(this.propertyDelegate);
        this.addSlot((Slot)new FurnaceResultSlot(playerInventory.player, container, 0, 107, 27));
        for (i = 1; i <= 6; ++i) {
            int x = 11 + (i - 1) % 3 * 18;
            int y = 17 + (i - 1) / 3 * 18;
            this.addSlot(new Slot(container, i, x, y));
        }
        this.addSlot(new Slot(this, container, 7, 134, 23){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(TagRegistry.SMALL_WATER_FILL) || stack.is(TagRegistry.LARGE_WATER_FILL);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.get(1) != 0;
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.get(0);
        int total = this.propertyDelegate.get(3);
        if (total == 0) {
            return 0;
        }
        return progress * arrowWidth / total;
    }

    public int getFluidLevel() {
        return this.propertyDelegate.get(2);
    }

    public int getCookingTime() {
        return this.propertyDelegate.get(0);
    }

    public int getRequiredDuration() {
        return this.propertyDelegate.get(3);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = slot.getItem();
        ItemStack copy = item.copy();
        if (index == 0) {
            if (!this.moveItemStackTo(item, 8, this.slots.size(), true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(item, copy);
        } else if (index >= 1 && index <= 6) {
            if (!this.moveItemStackTo(item, 8, this.slots.size(), false)) {
                return ItemStack.EMPTY;
            }
        } else if (index == 7) {
            if (!this.moveItemStackTo(item, 8, this.slots.size(), false)) {
                return ItemStack.EMPTY;
            }
        } else if (!this.moveItemStackTo(item, 1, 7, false)) {
            if (item.is((Item)ObjectRegistry.WOODEN_WATER_BUCKET.get()) || item.is(Items.WATER_BUCKET)) {
                if (!this.moveItemStackTo(item, 7, 8, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
        }
        if (item.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        slot.onTake(player, item);
        return copy;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

