/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.api.event;

import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;

public class HeartRenderEvent {
    protected final GuiGraphics guiGraphics;
    protected final Player player;
    protected int x;
    protected int y;
    protected int maxHealth;
    protected int health;
    protected int displayHealth;
    protected int absorption;
    protected boolean blinking;
    protected boolean hardcore;
    protected OverlayHeart overlayHeart;

    public HeartRenderEvent(GuiGraphics guiGraphics, Player player, int x, int y, int maxHealth, int currentHealth, int displayHealth, int absorption, boolean blinking, boolean hardcore, OverlayHeart overlayHeart) {
        this.guiGraphics = guiGraphics;
        this.player = player;
        this.x = x;
        this.y = y;
        this.maxHealth = maxHealth;
        this.health = currentHealth;
        this.displayHealth = displayHealth;
        this.absorption = absorption;
        this.blinking = blinking;
        this.hardcore = hardcore;
        this.overlayHeart = overlayHeart;
    }

    public GuiGraphics getGuiGraphics() {
        return this.guiGraphics;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public int getHealth() {
        return this.health;
    }

    public int getDisplayHealth() {
        return this.displayHealth;
    }

    public int getAbsorption() {
        return this.absorption;
    }

    public boolean isBlinking() {
        return this.blinking;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public Optional<OverlayHeart> getOverlayHeart() {
        return Optional.ofNullable(this.overlayHeart);
    }

    public static class Post
    extends HeartRenderEvent {
        public Post(GuiGraphics guiGraphics, Player player, int x, int y, int maxHealth, int currentHealth, int displayHealth, int absorption, boolean blinking, boolean hardcore, OverlayHeart overlayHeart) {
            super(guiGraphics, player, x, y, maxHealth, currentHealth, displayHealth, absorption, blinking, hardcore, overlayHeart);
        }
    }

    public static class Pre
    extends HeartRenderEvent {
        private boolean cancelled = false;

        public Pre(GuiGraphics guiGraphics, Player player, int x, int y, int maxHealth, int currentHealth, int displayHealth, int absorption, boolean blinking, boolean hardcore, OverlayHeart overlayHeart) {
            super(guiGraphics, player, x, y, maxHealth, currentHealth, displayHealth, absorption, blinking, hardcore, overlayHeart);
        }

        public void setCancelled(boolean cancel) {
            this.cancelled = cancel;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void setBlinking(boolean blinking) {
            this.blinking = blinking;
        }

        public void setHardcore(boolean hardcore) {
            this.hardcore = hardcore;
        }

        public void setOverlayHeart(OverlayHeart heart) {
            this.overlayHeart = heart;
        }
    }
}

