/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.worldgen.features.RandomBlockProximityPatchFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class RandomBlockProximityPatchFeature
extends Feature<RandomBlockProximityPatchFeatureConfig> {
    public RandomBlockProximityPatchFeature(Codec<RandomBlockProximityPatchFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RandomBlockProximityPatchFeatureConfig> context) {
        RandomBlockProximityPatchFeatureConfig randomPatchFeatureConfig = (RandomBlockProximityPatchFeatureConfig)context.config();
        RandomSource random = context.random();
        BlockPos blockPos = context.origin();
        WorldGenLevel structureWorldAccess = context.level();
        int placedFeatureCount = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int xzSpreadPlus1 = randomPatchFeatureConfig.xzSpread() + 1;
        int ySpreadPlus1 = randomPatchFeatureConfig.ySpread() + 1;
        for (int l = 0; l < randomPatchFeatureConfig.tries(); ++l) {
            mutable.setWithOffset((Vec3i)blockPos, random.nextInt(xzSpreadPlus1) - random.nextInt(xzSpreadPlus1), random.nextInt(ySpreadPlus1) - random.nextInt(ySpreadPlus1), random.nextInt(xzSpreadPlus1) - random.nextInt(xzSpreadPlus1));
            if (this.closeToBlock(structureWorldAccess, (BlockPos)mutable, randomPatchFeatureConfig.blockScanRange(), randomPatchFeatureConfig.blocksToCheckFor())) {
                if (!((PlacedFeature)randomPatchFeatureConfig.closeToBlockFeature().value()).place(structureWorldAccess, context.chunkGenerator(), random, (BlockPos)mutable)) continue;
                ++placedFeatureCount;
                continue;
            }
            if (!((PlacedFeature)randomPatchFeatureConfig.fallbackFeature().value()).place(structureWorldAccess, context.chunkGenerator(), random, (BlockPos)mutable)) continue;
            ++placedFeatureCount;
        }
        return placedFeatureCount > 0;
    }

    protected boolean closeToBlock(WorldGenLevel world, BlockPos pos, int searchRange, HolderSet<Block> blocksToSearchFor) {
        for (BlockPos currentPos : BlockPos.withinManhattan((BlockPos)pos, (int)searchRange, (int)searchRange, (int)searchRange)) {
            if (!world.getBlockState(currentPos).is(blocksToSearchFor)) continue;
            return true;
        }
        return false;
    }
}

