/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.worldgen.features.ColumnsFeatureConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.Nullable;

public class ColumnsFeature
extends Feature<ColumnsFeatureConfig> {
    private static final ImmutableList<Supplier<Block>> CANNOT_REPLACE_BLOCKS = ImmutableList.of(() -> Blocks.BEDROCK, () -> Blocks.CHEST, () -> Blocks.SPAWNER, PastelBlocks.DOWNSTONE);
    private static final int BIG_MAX_OFFSET = 5;
    private static final int BIG_COUNT = 50;
    private static final int SMALL_MAX_OFFSET = 8;
    private static final int SMALL_COUNT = 15;

    public ColumnsFeature(Codec<ColumnsFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ColumnsFeatureConfig> context) {
        int i = context.chunkGenerator().getSeaLevel();
        BlockPos blockPos = context.origin();
        WorldGenLevel structureWorldAccess = context.level();
        RandomSource random = context.random();
        ColumnsFeatureConfig config = (ColumnsFeatureConfig)context.config();
        if (!ColumnsFeature.canPlaceAt((LevelAccessor)structureWorldAccess, i, blockPos.mutable())) {
            return false;
        }
        int j = config.height().sample(random);
        boolean big = random.nextFloat() < 0.9f;
        int max_offset = Math.min(j, big ? 5 : 8);
        int count = big ? 50 : 15;
        boolean success = false;
        for (BlockPos blockPos2 : BlockPos.randomBetweenClosed((RandomSource)random, (int)count, (int)(blockPos.getX() - max_offset), (int)blockPos.getY(), (int)(blockPos.getZ() - max_offset), (int)(blockPos.getX() + max_offset), (int)blockPos.getY(), (int)(blockPos.getZ() + max_offset))) {
            int m = j - blockPos2.distManhattan((Vec3i)blockPos);
            if (m < 0) continue;
            success |= this.placeColumn((LevelAccessor)structureWorldAccess, i, blockPos2, m, config.reach().sample(random), config.blockState());
        }
        return success;
    }

    /*
     * Unable to fully structure code
     */
    private boolean placeColumn(LevelAccessor world, int seaLevel, BlockPos pos, int height, int reach, BlockState blockState) {
        success = false;
        it = BlockPos.betweenClosed((int)(pos.getX() - reach), (int)pos.getY(), (int)(pos.getZ() - reach), (int)(pos.getX() + reach), (int)pos.getY(), (int)(pos.getZ() + reach)).iterator();
        block0: while (true) {
            if (!it.hasNext()) {
                return success;
            }
            blockPos = (BlockPos)it.next();
            manhattanDistanceFromOrigin = blockPos.distManhattan((Vec3i)pos);
            currPos = ColumnsFeature.isReplaceable(world, seaLevel, blockPos) != false ? ColumnsFeature.moveDownToGround(world, seaLevel, blockPos.mutable(), manhattanDistanceFromOrigin) : ColumnsFeature.moveUpToAir(world, blockPos.mutable(), manhattanDistanceFromOrigin);
            if (currPos == null) continue;
            j = height - manhattanDistanceFromOrigin / 2;
            mutable = currPos.mutable();
            while (true) {
                if (j < 0) continue block0;
                if (ColumnsFeature.isReplaceable(world, seaLevel, (BlockPos)mutable)) {
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, blockState);
                    mutable.move(Direction.UP);
                    success = true;
                } else {
                    if (world.getBlockState((BlockPos)mutable).is(blockState.getBlock())) ** break;
                    continue block0;
                    mutable.move(Direction.UP);
                }
                --j;
            }
            break;
        }
    }

    @Nullable
    private static BlockPos moveDownToGround(LevelAccessor world, int seaLevel, BlockPos.MutableBlockPos mutablePos, int distance) {
        while (mutablePos.getY() > world.getMinBuildHeight() + 1 && distance > 0) {
            --distance;
            if (ColumnsFeature.canPlaceAt(world, seaLevel, mutablePos)) {
                return mutablePos;
            }
            mutablePos.move(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor world, int seaLevel, BlockPos.MutableBlockPos mutablePos) {
        if (!ColumnsFeature.isReplaceable(world, seaLevel, (BlockPos)mutablePos)) {
            return false;
        }
        BlockState blockState = world.getBlockState((BlockPos)mutablePos.move(Direction.DOWN));
        mutablePos.move(Direction.UP);
        return !blockState.isAir() && !blockState.is(PastelBlockTags.DEEPER_DOWN_FEATURE_REPLACEABLES) && !CANNOT_REPLACE_BLOCKS.stream().anyMatch(block -> blockState.getBlock() == block);
    }

    @Nullable
    private static BlockPos moveUpToAir(LevelAccessor world, BlockPos.MutableBlockPos mutablePos, int distance) {
        while (mutablePos.getY() < world.getMaxBuildHeight() && distance > 0) {
            --distance;
            BlockState blockState = world.getBlockState((BlockPos)mutablePos);
            if (CANNOT_REPLACE_BLOCKS.contains((Object)blockState.getBlock())) {
                return null;
            }
            if (blockState.isAir() || blockState.is(PastelBlockTags.DEEPER_DOWN_FEATURE_REPLACEABLES)) {
                return mutablePos;
            }
            mutablePos.move(Direction.UP);
        }
        return null;
    }

    private static boolean isReplaceable(LevelAccessor world, int seaLevel, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.isAir() || blockState.is(PastelBlockTags.DEEPER_DOWN_FEATURE_REPLACEABLES) || !blockState.getFluidState().isEmpty() && pos.getY() <= seaLevel;
    }
}

