/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.status_effects;

import earth.terrarium.pastel.attachments.data.LastKillData;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.neoforge.common.EffectCure;
import org.jetbrains.annotations.NotNull;

public class FrenzyStatusEffect
extends MobEffect {
    public static final long REQUIRE_KILL_EVERY_X_TICKS = 200L;

    public FrenzyStatusEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        if (!PastelMobEffects.effectsAreGettingStacked && !entity.hasEffect(PastelMobEffects.FRENZY)) {
            super.onEffectStarted(entity, amplifier);
        }
    }

    public void removeAttributeModifiers(AttributeMap attributes) {
        if (!PastelMobEffects.effectsAreGettingStacked) {
            super.removeAttributeModifiers(attributes);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        float potency;
        boolean scoredKillInTime;
        long lastKillTick = LastKillData.getLastKillTick(entity);
        long worldTime = entity.level().getGameTime();
        long lastKillTickDifference = worldTime - lastKillTick;
        boolean bl = scoredKillInTime = lastKillTick >= 0L && lastKillTickDifference < 200L;
        if (!scoredKillInTime && lastKillTickDifference % 200L == 0L) {
            this.updateAttributes(entity, amplifier, -1);
        }
        if ((potency = SleepStatusEffect.getSleepScaling(entity) * (float)(amplifier + 1) / 3.0f / 20.0f) > 0.0f && entity.getHealth() > potency) {
            entity.hurt(PastelDamageTypes.sleep(entity.level(), null), potency);
        }
        return true;
    }

    public void onKill(LivingEntity livingEntity, int amplifier) {
        this.updateAttributes(livingEntity, amplifier, 1);
    }

    public void updateAttributes(@NotNull LivingEntity entity, int amplifier, int increase) {
        AttributeMap attributes = entity.getAttributes();
        if (attributes != null) {
            this.createModifiers(amplifier, (entry, modifier) -> {
                AttributeInstance entityInstance = attributes.getInstance(entry);
                if (entityInstance != null) {
                    AttributeModifier appliedModifier = entityInstance.getModifier(modifier.id());
                    double newBaseValue = appliedModifier == null ? modifier.amount() : appliedModifier.amount();
                    double newValue = this.adjustModifierAmount(newBaseValue, modifier.amount(), amplifier, increase);
                    entityInstance.removeModifier(modifier);
                    entityInstance.addPermanentModifier(new AttributeModifier(modifier.id(), newValue, modifier.operation()));
                    entityInstance.getValue();
                }
            });
        }
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        cures.add(PastelMobEffects.Cures.SEDATIVES);
    }

    public double adjustModifierAmount(double existingValue, double additionalValue, int amplifier, int increase) {
        if (increase > 0) {
            return existingValue + additionalValue * (double)(amplifier + increase);
        }
        return existingValue - additionalValue * (double)(amplifier - increase);
    }
}

