/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import com.google.common.collect.EvictingQueue;
import earth.terrarium.pastel.registries.PastelBiomes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WorldAttenuation {
    private static final Map<Tracked, Queue<Float>> ATTENUATION_DATA = new HashMap<Tracked, Queue<Float>>();

    public static Data getData() {
        ClientLevel level = Minecraft.getInstance().level;
        long time = -1L;
        if (Minecraft.getInstance().level != null) {
            time = level.getGameTime();
        }
        return Cache.peek(time).orElse(Cache.swap(Data.create(), time));
    }

    public static void tick(Level level, Entity camera, boolean active) {
        if (!active) {
            return;
        }
        BlockPos camPos = BlockPos.containing((Position)camera.position()).above();
        BlockPos center = camPos.above(2);
        int checked = 0;
        float volBlocking = 0.0f;
        float pitchMods = 0.0f;
        float occlusion = 0.0f;
        Vec3 volumetrics = new Vec3(0.0, 0.0, 0.0);
        for (BlockPos check : BlockPos.randomInCube((RandomSource)level.getRandom(), (int)32, (BlockPos)center, (int)9)) {
            double volumetry = 1.0;
            if (!level.isInWorldBounds(check)) continue;
            ++checked;
            if (!level.getFluidState(check).isEmpty()) {
                volBlocking += 2.0f;
                pitchMods += 1.0f;
                occlusion += 0.5f;
                volumetrics.add(check.subtract((Vec3i)center).getCenter().normalize().scale(0.25));
                continue;
            }
            BlockState state = level.getBlockState(check);
            float hardness = state.getDestroySpeed((BlockGetter)level, check);
            if (!state.canOcclude() || state.is(BlockTags.LEAVES)) {
                volBlocking += 0.5f;
                volumetry = 0.5;
            } else if (hardness > 20.0f) {
                volBlocking += Math.min(5.0f, hardness / 10.0f);
                pitchMods += hardness / 30.0f;
            } else if (!state.isAir()) {
                volBlocking += 1.0f;
                volumetry = 0.0;
            }
            if (!state.isAir()) {
                occlusion += (float)Math.min((double)hardness / Math.sqrt(check.distSqr((Vec3i)center)) / 2.0, 5.0);
            }
            volumetrics = volumetrics.add(check.subtract((Vec3i)center).getCenter().normalize().scale(volumetry));
        }
        volumetrics = volumetrics.scale(1.0 / (double)checked);
        if (!level.getFluidState(camPos).isEmpty()) {
            pitchMods = (float)checked * 0.75f;
            volBlocking *= 1.2f;
            occlusion = pitchMods;
        }
        if (level.getBiome(camPos).is(PastelBiomes.BLACK_LANGAST) || level.getBiome(camPos).is(PastelBiomes.DEEP_BARRENS)) {
            occlusion += (float)checked / 2.0f;
        }
        Tracked.VOLUME.remember(volBlocking, checked);
        Tracked.PITCH.remember(pitchMods, checked);
        Tracked.OCCLUSION.remember(occlusion, checked);
        for (Direction.Axis axis : Direction.Axis.values()) {
            Tracked.remember(axis, (float)volumetrics.get(axis));
        }
    }

    private static float sample(Level level, BlockPos check) {
        BlockState state = level.getBlockState(check);
        float vol = 0.0f;
        if (state.isAir()) {
            vol = 1.0f;
        } else if (!state.canOcclude() || state.is(BlockTags.LEAVES)) {
            vol = 0.5f;
        }
        return vol;
    }

    static {
        for (Tracked tracked : Tracked.values()) {
            ATTENUATION_DATA.put(tracked, (Queue<Float>)EvictingQueue.create((int)tracked.size));
        }
    }

    private record Cache(Data data, long timeStamp) {
        private static Cache cache;

        private static Data swap(Data data, long time) {
            if (time == -1L) {
                return data;
            }
            cache = new Cache(data, time);
            return data;
        }

        private static Optional<Data> peek(long time) {
            if (cache == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(Cache.cache.timeStamp == time ? Cache.cache.data : null);
        }
    }

    public record Data(float volume, float pitch, float filtering, float x, float y, float z) {
        private static Data create() {
            return new Data(Tracked.VOLUME.get() * 2.0f, Tracked.PITCH.get(), Tracked.OCCLUSION.get() * 1.334f, Tracked.X.get(), Tracked.Y.get(), Tracked.Z.get());
        }
    }

    private static enum Tracked {
        VOLUME,
        PITCH,
        OCCLUSION,
        X(10),
        Y(10),
        Z(10);

        private final int size;

        private Tracked(int size) {
            this.size = size;
        }

        private Tracked() {
            this(20);
        }

        private void remember(float volBlocking, int checked) {
            ATTENUATION_DATA.get((Object)this).add(Float.valueOf(1.0f - Math.clamp(volBlocking / (float)checked, 0.0f, 1.0f)));
        }

        private static void remember(Direction.Axis axis, float val) {
            Tracked tracked = switch (axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> X;
                case Direction.Axis.Y -> Y;
                case Direction.Axis.Z -> Z;
            };
            ATTENUATION_DATA.get((Object)tracked).add(Float.valueOf(val));
        }

        private float get() {
            Queue<Float> dataFlow = ATTENUATION_DATA.get((Object)this);
            float averageAttenuation = 0.0f;
            for (Float attenuation : dataFlow) {
                if (attenuation.isNaN()) {
                    averageAttenuation += 1.0f;
                    continue;
                }
                averageAttenuation += attenuation.floatValue();
            }
            return averageAttenuation / (float)dataFlow.size();
        }
    }
}

