/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.PastelCommon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CraftingBlockSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private static List<CraftingBlockSoundInstance> playingSoundInstances = new ArrayList<CraftingBlockSoundInstance>();
    final ResourceKey<Level> worldKey;
    final BlockPos sourceBlockPos;
    final Block sourceBlock;
    final int maxDurationTicks;
    private int ticksPlayed = 0;
    private boolean done;

    protected CraftingBlockSoundInstance(SoundEvent soundEvent, ResourceKey<Level> worldKey, BlockPos sourceBlockPos, Block sourceBlock, int maxDurationTicks) {
        super(soundEvent, SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.worldKey = worldKey;
        this.sourceBlockPos = sourceBlockPos;
        this.sourceBlock = sourceBlock;
        this.maxDurationTicks = maxDurationTicks;
        this.looping = true;
        this.delay = 0;
        this.x = (double)sourceBlockPos.getX() + 0.5;
        this.y = (double)sourceBlockPos.getY() + 0.5;
        this.z = (double)sourceBlockPos.getZ() + 0.5;
        this.updateVolume();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void startSoundInstance(SoundEvent soundEvent, BlockPos sourceBlockPos, Block sourceBlock, int maxDurationTicks) {
        Minecraft client = Minecraft.getInstance();
        CraftingBlockSoundInstance.stopPlayingOnPos(sourceBlockPos);
        CraftingBlockSoundInstance newInstance = new CraftingBlockSoundInstance(soundEvent, (ResourceKey<Level>)client.level.dimension(), sourceBlockPos, sourceBlock, maxDurationTicks);
        playingSoundInstances.add(newInstance);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)newInstance);
    }

    public static void stopPlayingOnPos(BlockPos blockPos) {
        ArrayList<CraftingBlockSoundInstance> newInstances = new ArrayList<CraftingBlockSoundInstance>();
        for (CraftingBlockSoundInstance soundInstance : playingSoundInstances) {
            if (soundInstance.sourceBlockPos.equals((Object)blockPos)) {
                soundInstance.setDone();
                continue;
            }
            newInstances.add(soundInstance);
        }
        playingSoundInstances = newInstances;
    }

    public boolean isStopped() {
        return this.done;
    }

    public boolean canStartSilent() {
        return true;
    }

    private void updateVolume() {
        Minecraft client = Minecraft.getInstance();
        this.volume = Math.max(0.0f, 0.75f * (PastelCommon.CONFIG.BlockSoundVolume - (float)this.sourceBlockPos.distManhattan((Vec3i)client.player.blockPosition()) / 64.0f));
    }

    public void tick() {
        ++this.ticksPlayed;
        this.updateVolume();
        if (this.ticksPlayed == this.maxDurationTicks) {
            this.volume /= 2.0f;
        }
        if (this.ticksPlayed > this.maxDurationTicks || !Objects.equals(this.worldKey, Minecraft.getInstance().level.dimension()) || this.shouldStopPlaying()) {
            playingSoundInstances.remove((Object)this);
            this.setDone();
        }
    }

    private boolean shouldStopPlaying() {
        Minecraft client = Minecraft.getInstance();
        BlockState blockState = client.level.getBlockState(this.sourceBlockPos);
        return !blockState.getBlock().equals(this.sourceBlock);
    }

    protected final void setDone() {
        this.ticksPlayed = this.maxDurationTicks;
        this.done = true;
        this.looping = false;
    }
}

