/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render.animation;

import earth.terrarium.pastel.render.animation.DataSignature;
import earth.terrarium.pastel.render.animation.FlowHandler;
import earth.terrarium.pastel.render.animation.FlowState;
import earth.terrarium.pastel.render.animation.KeyFrame;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public final class FlowData<N extends Number> {
    private final DataSignature<N> signature;
    private final boolean valueTarget;
    private final HashMap<FlowState, KeyFrame<N>> stateListeners = new HashMap();
    private N value;
    private KeyFrame<N> nextKeyFrame;
    private KeyFrame<N> pastKeyFrame;

    private FlowData(DataSignature<N> signature, boolean valueTarget) {
        this.signature = signature;
        this.valueTarget = valueTarget;
        this.setAll(signature.initialValue);
    }

    public static <N extends Number> FlowData<N> create(DataSignature<N> signature, boolean valueTarget) {
        return new FlowData<N>(signature, valueTarget);
    }

    public static <N extends Number> FlowData<N> create(DataSignature<N> signature) {
        return FlowData.create(signature, true);
    }

    public N get() {
        return this.value;
    }

    public N last(float delta, long time) {
        return this.pastKeyFrame.at(delta, time);
    }

    public N target(float delta, long time) {
        return this.nextKeyFrame.at(delta, time);
    }

    public void setAll(N newValue) {
        this.value = newValue;
        KeyFrame<N> keyFrame = KeyFrame.simple(newValue);
        this.pastKeyFrame = keyFrame;
        this.nextKeyFrame = keyFrame;
    }

    public void setNextKeyFrame(KeyFrame<N> keyFrame) {
        if (this.valueTarget) {
            this.pastKeyFrame = KeyFrame.simple(this.value);
            this.nextKeyFrame = keyFrame;
        } else {
            this.pastKeyFrame = this.nextKeyFrame;
            this.nextKeyFrame = keyFrame;
        }
    }

    public void clear(boolean hard) {
        if (hard) {
            this.value = this.signature.initialValue;
            this.pastKeyFrame = this.signature.defaultKeyFrame;
            this.nextKeyFrame = this.signature.defaultKeyFrame;
        } else {
            this.setNextKeyFrame(this.signature.defaultKeyFrame);
        }
    }

    public void update(float tickDelta, float interpDelta, long time) {
        this.value = this.signature.handler.interpolate(this.signature.interpolation, this.pastKeyFrame.at(tickDelta, time), this.nextKeyFrame.at(tickDelta, time), interpDelta, time);
    }

    public FlowHandler<N> getHandler() {
        return this.signature.handler;
    }

    public void addStateListener(@NotNull FlowState state, KeyFrame<N> target) {
        this.stateListeners.put(state, target);
    }

    public void notifyStateChange(@NotNull FlowState state, boolean clearOnMiss) {
        if (clearOnMiss) {
            this.setNextKeyFrame(this.stateListeners.getOrDefault(state, this.signature.defaultKeyFrame));
            return;
        }
        if (this.stateListeners.containsKey(state)) {
            this.setNextKeyFrame(this.stateListeners.get(state));
        }
    }

    public static <N extends Number> FlowData<N> NULL() {
        return new FlowData(DataSignature.dummy(), true);
    }
}

