/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render.animation;

import earth.terrarium.pastel.render.animation.FlowData;
import earth.terrarium.pastel.render.animation.FlowHandler;
import earth.terrarium.pastel.render.animation.FlowState;
import earth.terrarium.pastel.render.animation.Interpolation;
import earth.terrarium.pastel.render.animation.KeyFrame;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class DataSignature<N extends Number> {
    private final Field reference;
    final FlowHandler<N> handler;
    final Interpolation interpolation;
    final Map<FlowState, KeyFrame<N>> stateHolder;
    final N initialValue;
    final KeyFrame<N> defaultKeyFrame;
    private static final DataSignature DUMMY = new DataSignature<Object>(null, null, null, null, null, Collections.EMPTY_MAP);

    DataSignature(Field reference, FlowHandler<N> handler, Interpolation interpolation, N initialValue, @Nullable KeyFrame<N> defaultKeyFrame, Map<FlowState, KeyFrame<N>> holderData) {
        this.reference = reference;
        this.handler = handler;
        this.interpolation = interpolation;
        this.initialValue = initialValue;
        this.stateHolder = Collections.unmodifiableMap(holderData);
        this.defaultKeyFrame = Objects.requireNonNullElseGet(defaultKeyFrame, () -> KeyFrame.simple(initialValue));
    }

    FlowData<N> instantiate() {
        FlowData<N> data = this.handler.createData(this);
        for (FlowState flowState : this.stateHolder.keySet()) {
            data.addStateListener(flowState, this.stateHolder.get(flowState));
        }
        return data;
    }

    void link(FlowData<?> data, Object target) throws IllegalAccessException {
        if (this.reference.canAccess(target)) {
            this.reference.set(target, data);
            return;
        }
        this.reference.setAccessible(true);
        this.reference.set(target, data);
        this.reference.setAccessible(false);
    }

    public static <N extends Number> DataSignature<N> dummy() {
        return DUMMY;
    }
}

