/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class PastelStructureTags {
    public static final TagKey<Structure> MYSTERIOUS_COMPASS_LOCATED = PastelStructureTags.of("mysterious_compass_located");
    public static final TagKey<Structure> UNLOCATABLE = PastelStructureTags.of("unlocatable");

    private static TagKey<Structure> of(String id) {
        return TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)PastelCommon.locate(id));
    }

    public static Optional<HolderSet.Named<Structure>> entriesOf(Level world, TagKey<Structure> tag) {
        Registry registry = world.registryAccess().registryOrThrow(Registries.STRUCTURE);
        return registry.getTag(tag);
    }

    public static boolean isIn(Level world, ResourceLocation id, TagKey<Structure> tag) {
        Registry registry = world.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Structure structure = (Structure)registry.get(id);
        Optional<HolderSet.Named<Structure>> tagEntries = PastelStructureTags.entriesOf(world, tag);
        if (tagEntries.isPresent()) {
            for (Holder entry : tagEntries.get()) {
                if (!((Structure)entry.value()).equals(structure)) continue;
                return true;
            }
        }
        return false;
    }
}

