/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.worldgen.features.AirCheckDiskFeature;
import earth.terrarium.pastel.worldgen.features.AshDunesFeature;
import earth.terrarium.pastel.worldgen.features.AshDunesFeatureConfig;
import earth.terrarium.pastel.worldgen.features.BlockStateFeatureConfig;
import earth.terrarium.pastel.worldgen.features.ColumnsFeature;
import earth.terrarium.pastel.worldgen.features.ColumnsFeatureConfig;
import earth.terrarium.pastel.worldgen.features.CrystalFormationFeature;
import earth.terrarium.pastel.worldgen.features.CrystalFormationFeatureFeatureConfig;
import earth.terrarium.pastel.worldgen.features.ExposedFossilFeature;
import earth.terrarium.pastel.worldgen.features.GiantGilledFungusFeature;
import earth.terrarium.pastel.worldgen.features.GilledFungusFeature;
import earth.terrarium.pastel.worldgen.features.GilledFungusFeatureConfig;
import earth.terrarium.pastel.worldgen.features.JadeiteLotusFeature;
import earth.terrarium.pastel.worldgen.features.JadeiteLotusFeatureConfig;
import earth.terrarium.pastel.worldgen.features.NephriteBlossomFeature;
import earth.terrarium.pastel.worldgen.features.NephriteBlossomFeatureConfig;
import earth.terrarium.pastel.worldgen.features.PillarFeature;
import earth.terrarium.pastel.worldgen.features.RandomBlockProximityPatchFeature;
import earth.terrarium.pastel.worldgen.features.RandomBlockProximityPatchFeatureConfig;
import earth.terrarium.pastel.worldgen.features.RandomBudsFeature;
import earth.terrarium.pastel.worldgen.features.RandomBudsFeaturesConfig;
import earth.terrarium.pastel.worldgen.features.SolidBlockCheckGeodeFeature;
import earth.terrarium.pastel.worldgen.features.TriStateVineFeature;
import earth.terrarium.pastel.worldgen.features.TriStateVineFeatureConfig;
import earth.terrarium.pastel.worldgen.features.WallPatchFeature;
import earth.terrarium.pastel.worldgen.features.WallPatchFeatureConfig;
import earth.terrarium.pastel.worldgen.features.WeightedRandomFeature;
import earth.terrarium.pastel.worldgen.features.WeightedRandomFeatureConfig;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PastelFeatures {
    private static final DeferredRegister<Feature<?>> REGISTER = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"pastel");
    public static Feature<WeightedRandomFeatureConfig> WEIGHTED_RANDOM_FEATURE = new WeightedRandomFeature(WeightedRandomFeatureConfig.CODEC);
    public static Feature<GeodeConfiguration> AIR_CHECK_GEODE = new SolidBlockCheckGeodeFeature((Codec<GeodeConfiguration>)GeodeConfiguration.CODEC);
    public static Feature<RandomBudsFeaturesConfig> RANDOM_BUDS = new RandomBudsFeature(RandomBudsFeaturesConfig.CODEC);
    public static Feature<OreConfiguration> AIR_CHECK_DISK = new AirCheckDiskFeature((Codec<OreConfiguration>)OreConfiguration.CODEC);
    public static Feature<GilledFungusFeatureConfig> GILLED_FUNGUS = new GilledFungusFeature(GilledFungusFeatureConfig.CODEC);
    public static Feature<GilledFungusFeatureConfig> GIANT_GILLED_FUNGUS = new GiantGilledFungusFeature(GilledFungusFeatureConfig.CODEC);
    public static Feature<NephriteBlossomFeatureConfig> NEPHRITE_BLOSSOM = new NephriteBlossomFeature(NephriteBlossomFeatureConfig.CODEC);
    public static Feature<JadeiteLotusFeatureConfig> JADEITE_LOTUS = new JadeiteLotusFeature(JadeiteLotusFeatureConfig.CODEC);
    public static Feature<TriStateVineFeatureConfig> TRISTATE_VINE = new TriStateVineFeature(TriStateVineFeatureConfig.CODEC);
    public static Feature<BlockStateFeatureConfig> PILLAR = new PillarFeature(BlockStateFeatureConfig.CODEC);
    public static Feature<ColumnsFeatureConfig> COLUMNS = new ColumnsFeature(ColumnsFeatureConfig.CODEC);
    public static Feature<CrystalFormationFeatureFeatureConfig> BLOB = new CrystalFormationFeature(CrystalFormationFeatureFeatureConfig.CODEC);
    public static Feature<RandomBlockProximityPatchFeatureConfig> RANDOM_BLOCK_PROXIMITY_PATCH = new RandomBlockProximityPatchFeature(RandomBlockProximityPatchFeatureConfig.CODEC);
    public static Feature<FossilFeatureConfiguration> EXPOSED_FOSSIL = new ExposedFossilFeature((Codec<FossilFeatureConfiguration>)FossilFeatureConfiguration.CODEC);
    public static Feature<WallPatchFeatureConfig> WALL_PATCH = new WallPatchFeature(WallPatchFeatureConfig.CODEC);
    public static Feature<AshDunesFeatureConfig> ASH_DUNES = new AshDunesFeature(AshDunesFeatureConfig.CODEC);

    public static void register(IEventBus bus) {
        PastelFeatures.registerFeature("weighted_random_feature", WEIGHTED_RANDOM_FEATURE);
        PastelFeatures.registerFeature("air_check_geode", AIR_CHECK_GEODE);
        PastelFeatures.registerFeature("random_buds", RANDOM_BUDS);
        PastelFeatures.registerFeature("air_check_disk", AIR_CHECK_DISK);
        PastelFeatures.registerFeature("gilled_fungus", GILLED_FUNGUS);
        PastelFeatures.registerFeature("giant_gilled_fungus", GIANT_GILLED_FUNGUS);
        PastelFeatures.registerFeature("nephrite_blossom", NEPHRITE_BLOSSOM);
        PastelFeatures.registerFeature("jadeite_lotus", JADEITE_LOTUS);
        PastelFeatures.registerFeature("tristate_vine", TRISTATE_VINE);
        PastelFeatures.registerFeature("pillar", PILLAR);
        PastelFeatures.registerFeature("columns", COLUMNS);
        PastelFeatures.registerFeature("crystal_formation", BLOB);
        PastelFeatures.registerFeature("random_block_proximity_patch", RANDOM_BLOCK_PROXIMITY_PATCH);
        PastelFeatures.registerFeature("exposed_fossil", EXPOSED_FOSSIL);
        PastelFeatures.registerFeature("wall_patch", WALL_PATCH);
        PastelFeatures.registerFeature("ash_dunes", ASH_DUNES);
        REGISTER.register(bus);
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> void registerFeature(String name, F feature) {
        REGISTER.register(name, () -> feature);
    }
}

