/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.data.DatagenProxy;
import earth.terrarium.pastel.items.magic_items.EnderSpliceItem;
import earth.terrarium.pastel.items.trinkets.GleamingPinItem;
import earth.terrarium.pastel.registries.DeferredRegistrar;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.level.block.Block;

public class PastelEnchantments {
    private static final DeferredRegistrar.Contextual<DatagenProxy.ProvidedTagBuilderBuilder<Item>> ITEM_TAG_REGISTRAR = new DeferredRegistrar.Contextual(DatagenProxy.IS_DATAGEN);
    private static final DeferredRegistrar.Contextual<DatagenProxy.BootstrapContext<Enchantment>> BOOTSTRAP_REGISTAR = new DeferredRegistrar.Contextual(DatagenProxy.IS_DATAGEN);
    private static final DeferredRegistrar.KeyedContextual<ResourceKey<Enchantment>, DatagenProxy.ProvidedTagBuilderBuilder<Enchantment>> ENCHANTMENT_TAG_REGISTRAR = new DeferredRegistrar.KeyedContextual(DatagenProxy.IS_DATAGEN);
    public static final ResourceKey<Enchantment> BIG_CATCH = new Builder("big_catch", 2, 3, new Enchantment.Cost(20, 0), new Enchantment.Cost(50, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.FISHING_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.FISHING_ENCHANTABLE)).register();
    public static final ResourceKey<Enchantment> CLOVERS_FAVOR = new Builder("clovers_favor", 2, 3, new Enchantment.Cost(20, 0), new Enchantment.Cost(50, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.empty()).withEnchantable(provider -> provider.addTag(ItemTags.SWORD_ENCHANTABLE).addOptionalTag(ResourceLocation.parse((String)"malum:scythe"))).withExclusiveSet((key, provider) -> provider.add(Enchantments.LOOTING).addOptional(ResourceLocation.parse((String)"malum:spirit_plunder"))).register();
    public static final ResourceKey<Enchantment> DISARMING = new Builder("disarming", 1, 2, new Enchantment.Cost(10, 0), new Enchantment.Cost(40, 0), 8, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.SWORD_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.WEAPON_ENCHANTABLE)).register();
    public static final ResourceKey<Enchantment> EXUBERANCE = new Builder("exuberance", 5, 5, new Enchantment.Cost(10, 0), new Enchantment.Cost(40, 0), 2, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.SWORD_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.WEAPON_ENCHANTABLE).addTag(ItemTags.MINING_LOOT_ENCHANTABLE).addTag(PastelItemTags.FISHING_RODS).addOptionalTag(ResourceLocation.parse((String)"malum:scythe"))).register();
    public static final ResourceKey<Enchantment> FIRST_STRIKE = new Builder("first_strike", 2, 2, new Enchantment.Cost(10, 0), new Enchantment.Cost(40, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.SWORD_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.WEAPON_ENCHANTABLE).addOptionalTag(ResourceLocation.parse((String)"malum:scythe"))).register();
    public static final ResourceKey<Enchantment> FOUNDRY = new Builder("foundry", 2, 1, new Enchantment.Cost(15, 0), new Enchantment.Cost(65, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.MINING_LOOT_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.MINING_LOOT_ENCHANTABLE).addTag(PastelItemTags.FISHING_RODS)).withExclusiveSet((key, provider) -> provider.add(Enchantments.SILK_TOUCH).addOptional(ResourceLocation.parse((String)"gofish:deepfry"))).register();
    public static final ResourceKey<Enchantment> IMPROVED_CRITICAL = new Builder("improved_critical", 2, 2, new Enchantment.Cost(10, 0), new Enchantment.Cost(40, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.SWORD_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.WEAPON_ENCHANTABLE).addOptionalTag(ResourceLocation.parse((String)"malum:scythe"))).withExclusiveSet((key, provider) -> provider.add(Enchantments.SHARPNESS).addOptional(ResourceLocation.parse((String)"malum:haunted"))).register();
    public static final ResourceKey<Enchantment> INDESTRUCTIBLE = new Builder("indestructible", 2, 1, new Enchantment.Cost(30, 0), new Enchantment.Cost(60, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.empty()).withEnchantable(provider -> provider.addTag(ItemTags.DURABILITY_ENCHANTABLE)).withExclusiveSet((key, provider) -> provider.add(Enchantments.INFINITY).add(Enchantments.UNBREAKING).add(Enchantments.EFFICIENCY).add(Enchantments.MENDING).add(Enchantments.PROTECTION).add(Enchantments.BINDING_CURSE)).register();
    public static final ResourceKey<Enchantment> INERTIA = new Builder("inertia", 1, 3, new Enchantment.Cost(10, 0), new Enchantment.Cost(40, 0), 8, List.of(EquipmentSlotGroup.MAINHAND), Optional.empty()).withEnchantable(provider -> provider.addTag(ItemTags.MINING_LOOT_ENCHANTABLE)).withExclusiveSet((key, provider) -> provider.add(Enchantments.EFFICIENCY)).register();
    public static final ResourceKey<Enchantment> INEXORABLE = new Builder("inexorable", 1, 1, new Enchantment.Cost(50, 0), new Enchantment.Cost(100, 0), 8, List.of(EquipmentSlotGroup.MAINHAND, EquipmentSlotGroup.OFFHAND, EquipmentSlotGroup.CHEST), Optional.of(ItemTags.CHEST_ARMOR_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.CHEST_ARMOR_ENCHANTABLE).addTag(ItemTags.MINING_LOOT_ENCHANTABLE).addTag(ItemTags.TRIDENT_ENCHANTABLE)).register();
    public static final ResourceKey<Enchantment> INVENTORY_INSERTION = new Builder("inventory_insertion", 2, 1, new Enchantment.Cost(15, 0), new Enchantment.Cost(45, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.MINING_LOOT_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.MINING_ENCHANTABLE).addTag(ItemTags.WEAPON_ENCHANTABLE).addTag(ItemTags.BOW_ENCHANTABLE).addTag(ItemTags.CROSSBOW_ENCHANTABLE).addTag(PastelItemTags.FISHING_RODS).addOptionalTag(ResourceLocation.parse((String)"malum:scythe"))).register();
    public static final ResourceKey<Enchantment> PEST_CONTROL = new Builder("pest_control", 1, 1, new Enchantment.Cost(10, 0), new Enchantment.Cost(30, 0), 8, List.of(EquipmentSlotGroup.MAINHAND), Optional.empty()).withEnchantable(provider -> provider.addTag(ItemTags.MINING_LOOT_ENCHANTABLE)).withExclusiveSet((key, provider) -> provider.add(PastelEnchantments.of("resonance"))).register();
    public static final ResourceKey<Enchantment> RAZING = new Builder("razing", 5, 3, new Enchantment.Cost(20, 0), new Enchantment.Cost(30, 0), 2, List.of(EquipmentSlotGroup.MAINHAND), Optional.empty()).withEnchantable(provider -> provider.addTag(ItemTags.MINING_LOOT_ENCHANTABLE)).withExclusiveSet((key, provider) -> provider.add(Enchantments.FORTUNE)).register();
    public static final ResourceKey<Enchantment> RESONANCE = new Builder("resonance", 1, 1, new Enchantment.Cost(25, 0), new Enchantment.Cost(100, 0), 8, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.MINING_LOOT_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.MINING_ENCHANTABLE).add(((EnderSpliceItem)((Object)((Object)PastelItems.ENDER_SPLICE.get()))).builtInRegistryHolder().key()).add(((Item)PastelItems.EXCHANGING_STAFF.get()).builtInRegistryHolder().key())).withExclusiveSet((key, provider) -> provider.addTag(EnchantmentTags.MINING_EXCLUSIVE).add(PEST_CONTROL)).register();
    public static final ResourceKey<Enchantment> SERENDIPITY_REEL = new Builder("serendipity_reel", 2, 2, new Enchantment.Cost(40, 0), new Enchantment.Cost(120, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.empty()).withEnchantable(provider -> provider.addTag(ItemTags.FISHING_ENCHANTABLE)).register();
    public static final ResourceKey<Enchantment> SNIPING = new Builder("sniping", 1, 2, new Enchantment.Cost(20, 0), new Enchantment.Cost(50, 0), 8, List.of(EquipmentSlotGroup.MAINHAND), Optional.empty()).withEnchantable(provider -> provider.addTag(ItemTags.CROSSBOW_ENCHANTABLE).add(((GleamingPinItem)((Object)((Object)PastelItems.GLEAMING_PIN.get()))).builtInRegistryHolder().key())).withExclusiveSet((key, provider) -> provider.add(Enchantments.MULTISHOT)).register();
    public static final ResourceKey<Enchantment> STEADFAST = new Builder("steadfast", 10, 1, new Enchantment.Cost(30, 0), new Enchantment.Cost(60, 0), 1, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.DURABILITY_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.DURABILITY_ENCHANTABLE).addTag(ItemTags.MINING_ENCHANTABLE).addTag(ItemTags.VANISHING_ENCHANTABLE).addOptionalTag(ResourceLocation.parse((String)"trinkets:enchantable/enchantable"))).register();
    public static final ResourceKey<Enchantment> TIGHT_GRIP = new Builder("tight_grip", 2, 2, new Enchantment.Cost(5, 0), new Enchantment.Cost(35, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.SWORD_ENCHANTABLE)).withEffects((key, ctx, builder) -> builder.withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(PastelCommon.locate("enchantment.tight_grip"), Attributes.ATTACK_SPEED, (LevelBasedValue)LevelBasedValue.perLevel((float)0.0625f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))).withEnchantable(provider -> provider.addTag(ItemTags.SWORD_ENCHANTABLE).addOptionalTag(ResourceLocation.parse((String)"malum:scythe"))).withExclusiveSet((key, provider) -> provider.addOptional(ResourceLocation.parse((String)"malum:rebound"))).register();
    public static final ResourceKey<Enchantment> TREASURE_HUNTER = new Builder("treasure_hunter", 2, 3, new Enchantment.Cost(15, 0), new Enchantment.Cost(45, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.of(ItemTags.SWORD_ENCHANTABLE)).withEnchantable(provider -> provider.addTag(ItemTags.WEAPON_ENCHANTABLE).addOptionalTag(ResourceLocation.parse((String)"malum:scythe"))).withExclusiveSet((key, provider) -> provider.add(Enchantments.LOOTING).addOptional(ResourceLocation.parse((String)"malum:spirit_plunder"))).register();
    public static final ResourceKey<Enchantment> VOIDING = new Builder("voiding", 2, 1, new Enchantment.Cost(25, 0), new Enchantment.Cost(50, 0), 4, List.of(EquipmentSlotGroup.MAINHAND), Optional.empty()).withEnchantable(provider -> provider.addTag(ItemTags.MINING_LOOT_ENCHANTABLE).add(((Block)PastelBlocks.BOTTOMLESS_BUNDLE.get()).asItem().builtInRegistryHolder().key())).register();

    private static ResourceKey<Enchantment> of(String id) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)PastelCommon.locate(id));
    }

    public static TagKey<Item> getEnchantableTag(ResourceKey<Enchantment> key) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)PastelCommon.locate("enchantable/" + key.location().getPath()));
    }

    public static TagKey<Enchantment> getExclusiveSetTag(ResourceKey<Enchantment> key) {
        return TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)PastelCommon.locate("exclusive_set/" + key.location().getPath()));
    }

    public static ResourceKey<Enchantment> getCloakKey(ResourceKey<Enchantment> key) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)PastelCommon.locate("cloaked/" + key.location().getPath()));
    }

    public static void provideItemTags(DatagenProxy.ProvidedTagBuilderBuilder<Item> builder) {
        ITEM_TAG_REGISTRAR.flush(builder);
    }

    public static void provideEnchantmentTags(DatagenProxy.ProvidedTagBuilderBuilder<Enchantment> builder) {
        TagsProvider.TagAppender<Enchantment> enchantments = builder.build(PastelEnchantmentTags.SPECTRUM_ENCHANTMENT);
        ENCHANTMENT_TAG_REGISTRAR.streamKeys().map(ResourceKey::location).sorted().forEach(arg_0 -> enchantments.addOptional(arg_0));
        ENCHANTMENT_TAG_REGISTRAR.flush(builder);
    }

    public static void provideEnchantments(DatagenProxy.BootstrapContext<Enchantment> ctx) {
        BOOTSTRAP_REGISTAR.flush(ctx);
    }

    private static class Builder {
        private final ResourceKey<Enchantment> key;
        private final int weight;
        private final int maxLevel;
        private final Enchantment.Cost minCost;
        private final Enchantment.Cost maxCost;
        private final int anvilCost;
        private final List<EquipmentSlotGroup> slots;
        private final Optional<TagKey<Item>> primaryItems;
        private EnchantmentBuilderCallback effectsBuilder = (key, ctx, builder) -> builder;
        private DatagenProxy.TagBuilderCallback<Item> enchantableBuilder = provider -> provider;
        private DatagenProxy.KeyedTagBuilderCallback<Enchantment> exclusiveSetBuilder = (key, provider) -> provider;

        public Builder(String name, int weight, int maxLevel, Enchantment.Cost minCost, Enchantment.Cost maxCost, int anvilCost, List<EquipmentSlotGroup> slots, Optional<TagKey<Item>> primaryItems) {
            this.key = PastelEnchantments.of(name);
            this.weight = weight;
            this.maxLevel = maxLevel;
            this.minCost = minCost;
            this.maxCost = maxCost;
            this.anvilCost = anvilCost;
            this.slots = slots;
            this.primaryItems = primaryItems;
        }

        public Builder withEffects(EnchantmentBuilderCallback enchantmentBuilder) {
            this.effectsBuilder = enchantmentBuilder;
            return this;
        }

        public Builder withEnchantable(DatagenProxy.TagBuilderCallback<Item> enchantableBuilder) {
            this.enchantableBuilder = enchantableBuilder;
            return this;
        }

        public Builder withExclusiveSet(DatagenProxy.KeyedTagBuilderCallback<Enchantment> exclusiveSetBuilder) {
            this.exclusiveSetBuilder = exclusiveSetBuilder;
            return this;
        }

        public ResourceKey<Enchantment> register() {
            BOOTSTRAP_REGISTAR.defer(ctx -> {
                HolderSet.Named supportedItemsList = ctx.items().getOrThrow(PastelEnchantments.getEnchantableTag(this.key));
                Optional<HolderSet> primaryItemsList = this.primaryItems.map(tag -> ctx.items().getOrThrow(tag));
                Enchantment.EnchantmentDefinition definition = new Enchantment.EnchantmentDefinition((HolderSet)supportedItemsList, primaryItemsList, this.weight, this.maxLevel, this.minCost, this.maxCost, this.anvilCost, this.slots);
                Enchantment.Builder enchantment = new Enchantment.Builder(definition).exclusiveWith((HolderSet)ctx.enchantments().getOrThrow(PastelEnchantments.getExclusiveSetTag(this.key)));
                ctx.registerable().register(this.key, (Object)this.effectsBuilder.build(this.key, (DatagenProxy.BootstrapContext<Enchantment>)ctx, enchantment).build(this.key.location()));
            });
            ENCHANTMENT_TAG_REGISTRAR.defer(this.key, (key, ctx) -> this.exclusiveSetBuilder.build((ResourceKey<Enchantment>)key, ctx.build(PastelEnchantments.getExclusiveSetTag((ResourceKey<Enchantment>)key))));
            ITEM_TAG_REGISTRAR.defer(ctx -> this.enchantableBuilder.build(ctx.build(PastelEnchantments.getEnchantableTag(this.key))));
            return this.key;
        }
    }

    private static interface EnchantmentBuilderCallback {
        public Enchantment.Builder build(ResourceKey<Enchantment> var1, DatagenProxy.BootstrapContext<Enchantment> var2, Enchantment.Builder var3);
    }
}

