/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.api.item.ItemPickupListener;
import earth.terrarium.pastel.api.item.SplitDamageHandler;
import earth.terrarium.pastel.capabilities.AreaMiningHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.items.magic_items.KnowledgeGemItem;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class PastelCapabilityHandlers {
    public static void registerBlocks(RegisterCapabilitiesEvent event) {
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.FUSION_SHRINE, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.PEDESTAL, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.SPIRIT_INSTILLER, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.ENCHANTER, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.CINDERHEARTH, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.CRYSTALLARIEUM, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.TITRATION_BARREL, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.POTION_WORKSHOP, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.BLOCK_PLACER, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.BOTTOMLESS_BUNDLE, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.ITEM_BOWL, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.COLOR_PICKER, event);
        PastelCapabilityHandlers.containerBlockBE(PastelBlockEntities.CRYSTAL_APOTHECARY, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.BLACK_HOLE_CHEST, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.FABRICATION_CHEST, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.COMPACTING_CHEST, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.HEARTBOUND_CHEST, event);
        PastelCapabilityHandlers.standardBlockBE(PastelBlockEntities.AMPHORA, event);
        PastelCapabilityHandlers.standardFluidBE(PastelBlockEntities.FUSION_SHRINE, event);
        PastelCapabilityHandlers.standardFluidBE(PastelBlockEntities.CRYSTALLARIEUM, event);
        PastelCapabilityHandlers.standardFluidBE(PastelBlockEntities.TITRATION_BARREL, event);
    }

    public static void registerItems(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, v) -> new FluidHandlerItemStackSimple.Consumable(() -> PastelDataComponentTypes.MERMAIDS_GEM, stack, 1000), new ItemLike[]{(ItemLike)PastelItems.MERMAIDS_GEM.get()});
        event.registerItem(PastelCapabilities.Pickup.ITEM, (stack, v) -> (ItemPickupListener)stack.getItem(), new ItemLike[]{PastelBlocks.BOTTOMLESS_BUNDLE.asItem()});
        event.registerItem(PastelCapabilities.Misc.MINING, (stack, v) -> (AreaMiningHandler)stack.getItem(), new ItemLike[]{PastelItems.MALACHITE_WORKSTAFF, PastelItems.GLASS_CREST_WORKSTAFF});
        event.registerItem(PastelCapabilities.Misc.SPLIT_DAMAGE, (stack, v) -> (SplitDamageHandler)stack.getItem(), new ItemLike[]{PastelItems.GLASS_CREST_ULTRA_GREATSWORD, PastelItems.MALACHITE_BIDENT, PastelItems.FRACTAL_GLASS_CREST_BIDENT, PastelItems.FEROCIOUS_GLASS_CREST_BIDENT, PastelItems.DRAGON_TALON, PastelItems.DREAMFLAYER, PastelItems.KNOTTED_SWORD, PastelItems.NECTAR_LANCE});
        event.registerItem(PastelCapabilities.Misc.XP, KnowledgeGemItem.Wrapper::new, new ItemLike[]{PastelItems.KNOWLEDGE_GEM});
    }

    private static void containerBlockBE(Supplier<? extends BlockEntityType<? extends Container>> type, RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, type.get(), (container, dir) -> new InvWrapper((Container)container));
    }

    private static void standardBlockBE(Supplier<? extends BlockEntityType<? extends SidedCapabilityProvider>> type, RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, type.get(), (rec$, x$0) -> ((SidedCapabilityProvider)rec$).exposeItemHandlersChecked((Direction)x$0));
    }

    private static void standardFluidBE(Supplier<? extends BlockEntityType<? extends SidedCapabilityProvider>> type, RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, type.get(), (rec$, x$0) -> ((SidedCapabilityProvider)rec$).exposeFluidHandlersChecked((Direction)x$0));
    }
}

