/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.blocks.PlacedItemBlockEntity;
import earth.terrarium.pastel.blocks.amphora.AmphoraBlockEntity;
import earth.terrarium.pastel.blocks.block_flooder.BlockFlooderBlockEntity;
import earth.terrarium.pastel.blocks.bottomless_bundle.BottomlessBundleBlockEntity;
import earth.terrarium.pastel.blocks.bottomless_bundle.BottomlessBundleBlockEntityRenderer;
import earth.terrarium.pastel.blocks.chests.BlackHoleChestBlockEntity;
import earth.terrarium.pastel.blocks.chests.BlackHoleChestBlockEntityRenderer;
import earth.terrarium.pastel.blocks.chests.CompactingChestBlockEntity;
import earth.terrarium.pastel.blocks.chests.CompactingChestBlockEntityRenderer;
import earth.terrarium.pastel.blocks.chests.FabricationChestBlockEntity;
import earth.terrarium.pastel.blocks.chests.FabricationChestBlockEntityRenderer;
import earth.terrarium.pastel.blocks.chests.HeartboundChestBlockEntity;
import earth.terrarium.pastel.blocks.chests.HeartboundChestBlockEntityRenderer;
import earth.terrarium.pastel.blocks.chests.PastelChestBlockEntityRenderer;
import earth.terrarium.pastel.blocks.cinderhearth.CinderhearthBlockEntity;
import earth.terrarium.pastel.blocks.crystallarieum.CrystallarieumBlockEntity;
import earth.terrarium.pastel.blocks.crystallarieum.CrystallarieumBlockEntityRenderer;
import earth.terrarium.pastel.blocks.decoration.ProjectorBlockEntity;
import earth.terrarium.pastel.blocks.decoration.ProjectorBlockEntityRenderer;
import earth.terrarium.pastel.blocks.deeper_down.HummingstoneBlockEntity;
import earth.terrarium.pastel.blocks.enchanter.EnchanterBlockEntity;
import earth.terrarium.pastel.blocks.enchanter.EnchanterBlockEntityRenderer;
import earth.terrarium.pastel.blocks.ender.EnderDropperBlockEntity;
import earth.terrarium.pastel.blocks.ender.EnderHopperBlockEntity;
import earth.terrarium.pastel.blocks.energy.ColorPickerBlockEntity;
import earth.terrarium.pastel.blocks.energy.ColorPickerBlockEntityRenderer;
import earth.terrarium.pastel.blocks.energy.CrystalApothecaryBlockEntity;
import earth.terrarium.pastel.blocks.fusion_shrine.FusionShrineBlockEntity;
import earth.terrarium.pastel.blocks.fusion_shrine.FusionShrineBlockEntityRenderer;
import earth.terrarium.pastel.blocks.item_bowl.ItemBowlBlockEntity;
import earth.terrarium.pastel.blocks.item_bowl.ItemBowlBlockEntityRenderer;
import earth.terrarium.pastel.blocks.item_roundel.ItemRoundelBlockEntity;
import earth.terrarium.pastel.blocks.item_roundel.ItemRoundelBlockEntityRenderer;
import earth.terrarium.pastel.blocks.jade_vines.JadeVineRootsBlockEntity;
import earth.terrarium.pastel.blocks.jade_vines.JadeVineRootsBlockEntityRenderer;
import earth.terrarium.pastel.blocks.memory.MemoryBlockEntity;
import earth.terrarium.pastel.blocks.mob_head.PastelSkullBlock;
import earth.terrarium.pastel.blocks.mob_head.PastelWallSkullBlock;
import earth.terrarium.pastel.blocks.particle_spawner.ParticleSpawnerBlockEntity;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntity;
import earth.terrarium.pastel.blocks.pastel_network.nodes.PastelNodeBlockEntityRenderer;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntityRenderer;
import earth.terrarium.pastel.blocks.potion_workshop.PotionWorkshopBlockEntity;
import earth.terrarium.pastel.blocks.present.PresentBlockEntity;
import earth.terrarium.pastel.blocks.redstone.BlockBreakerBlockEntity;
import earth.terrarium.pastel.blocks.redstone.BlockPlacerBlockEntity;
import earth.terrarium.pastel.blocks.redstone.PlayerDetectorBlockEntity;
import earth.terrarium.pastel.blocks.redstone.RedstoneCalculatorBlockEntity;
import earth.terrarium.pastel.blocks.redstone.RedstoneTransceiverBlockEntity;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlockEntityRenderer;
import earth.terrarium.pastel.blocks.spirit_sallow.OminousSaplingBlockEntity;
import earth.terrarium.pastel.blocks.structure.DeepLightBlockEntity;
import earth.terrarium.pastel.blocks.structure.DeepLightBlockEntityRenderer;
import earth.terrarium.pastel.blocks.structure.PlayerTrackerBlockEntity;
import earth.terrarium.pastel.blocks.structure.PlayerTrackingBlockEntityRenderer;
import earth.terrarium.pastel.blocks.structure.PreservationBlockDetectorBlockEntity;
import earth.terrarium.pastel.blocks.structure.PreservationControllerBlockEntity;
import earth.terrarium.pastel.blocks.structure.PreservationControllerBlockEntityRenderer;
import earth.terrarium.pastel.blocks.structure.PreservationRoundelBlockEntity;
import earth.terrarium.pastel.blocks.structure.TreasureChestBlockEntity;
import earth.terrarium.pastel.blocks.titration_barrel.TitrationBarrelBlockEntity;
import earth.terrarium.pastel.blocks.upgrade.UpgradeBlockBlockEntityRenderer;
import earth.terrarium.pastel.blocks.upgrade.UpgradeBlockEntity;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PastelBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> REGISTER = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"pastel");
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<OminousSaplingBlockEntity>> OMINOUS_SAPLING;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PedestalBlockEntity>> PEDESTAL;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<FusionShrineBlockEntity>> FUSION_SHRINE;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<EnchanterBlockEntity>> ENCHANTER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<ItemBowlBlockEntity>> ITEM_BOWL;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<ItemRoundelBlockEntity>> ITEM_ROUNDEL;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<EnderDropperBlockEntity>> ENDER_DROPPER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<EnderHopperBlockEntity>> ENDER_HOPPER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<ParticleSpawnerBlockEntity>> PARTICLE_SPAWNER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<UpgradeBlockEntity>> UPGRADE_BLOCK;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<BottomlessBundleBlockEntity>> BOTTOMLESS_BUNDLE;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PotionWorkshopBlockEntity>> POTION_WORKSHOP;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<CrystallarieumBlockEntity>> CRYSTALLARIEUM;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<CinderhearthBlockEntity>> CINDERHEARTH;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<CrystalApothecaryBlockEntity>> CRYSTAL_APOTHECARY;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<ColorPickerBlockEntity>> COLOR_PICKER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<CompactingChestBlockEntity>> COMPACTING_CHEST;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<FabricationChestBlockEntity>> FABRICATION_CHEST;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<HeartboundChestBlockEntity>> HEARTBOUND_CHEST;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<BlackHoleChestBlockEntity>> BLACK_HOLE_CHEST;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<TreasureChestBlockEntity>> PRESERVATION_CHEST;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<AmphoraBlockEntity>> AMPHORA;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<ProjectorBlockEntity>> PROJECTOR;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PlayerDetectorBlockEntity>> PLAYER_DETECTOR;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<RedstoneCalculatorBlockEntity>> REDSTONE_CALCULATOR;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<RedstoneTransceiverBlockEntity>> REDSTONE_TRANSCEIVER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockPlacerBlockEntity>> BLOCK_PLACER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockBreakerBlockEntity>> BLOCK_BREAKER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockFlooderBlockEntity>> BLOCK_FLOODER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<SpiritInstillerBlockEntity>> SPIRIT_INSTILLER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<MemoryBlockEntity>> MEMORY;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<JadeVineRootsBlockEntity>> JADE_VINE_ROOTS;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PresentBlockEntity>> PRESENT;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<TitrationBarrelBlockEntity>> TITRATION_BARREL;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PastelNodeBlockEntity>> PASTEL_NODE;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<HummingstoneBlockEntity>> HUMMINGSTONE;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PlacedItemBlockEntity>> PLACED_ITEM;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PreservationControllerBlockEntity>> PRESERVATION_CONTROLLER;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PreservationRoundelBlockEntity>> PRESERVATION_ROUNDEL;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PreservationBlockDetectorBlockEntity>> PRESERVATION_BLOCK_DETECTOR;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<DeepLightBlockEntity>> DEEP_LIGHT;
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<PlayerTrackerBlockEntity>> PLAYER_TRACKING;

    private static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> register(String id, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> ... blocks) {
        return PastelBlockEntities.register(id, factory, () -> Arrays.asList(blocks).stream().map(Supplier::get).toList());
    }

    private static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> register(String id, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<List<? extends Block>> blocks) {
        return REGISTER.register(id, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])((List)blocks.get()).toArray(new Block[0])).build(null));
    }

    public static void register(IEventBus bus) {
        OMINOUS_SAPLING = PastelBlockEntities.register("ominous_sapling_block_entity", OminousSaplingBlockEntity::new, new Supplier[]{PastelBlocks.OMINOUS_SAPLING});
        PEDESTAL = PastelBlockEntities.register("pedestal_block_entity", PedestalBlockEntity::new, new Supplier[]{PastelBlocks.PEDESTAL_BASIC_AMETHYST, PastelBlocks.PEDESTAL_BASIC_TOPAZ, PastelBlocks.PEDESTAL_BASIC_CITRINE, PastelBlocks.PEDESTAL_ALL_BASIC, PastelBlocks.PEDESTAL_ONYX, PastelBlocks.PEDESTAL_MOONSTONE});
        FUSION_SHRINE = PastelBlockEntities.register("fusion_shrine_block_entity", FusionShrineBlockEntity::new, new Supplier[]{PastelBlocks.FUSION_SHRINE_BASALT, PastelBlocks.FUSION_SHRINE_CALCITE});
        ENCHANTER = PastelBlockEntities.register("enchanter_block_entity", EnchanterBlockEntity::new, new Supplier[]{PastelBlocks.ENCHANTER});
        ITEM_BOWL = PastelBlockEntities.register("item_bowl_block_entity", ItemBowlBlockEntity::new, new Supplier[]{PastelBlocks.ITEM_BOWL_BASALT, PastelBlocks.ITEM_BOWL_CALCITE});
        ITEM_ROUNDEL = PastelBlockEntities.register("item_roundel", ItemRoundelBlockEntity::new, new Supplier[]{PastelBlocks.ITEM_ROUNDEL});
        ENDER_DROPPER = PastelBlockEntities.register("ender_dropper", EnderDropperBlockEntity::new, new Supplier[]{PastelBlocks.ENDER_DROPPER});
        ENDER_HOPPER = PastelBlockEntities.register("ender_hopper", EnderHopperBlockEntity::new, new Supplier[]{PastelBlocks.ENDER_HOPPER});
        PARTICLE_SPAWNER = PastelBlockEntities.register("particle_spawner", ParticleSpawnerBlockEntity::new, new Supplier[]{PastelBlocks.PARTICLE_SPAWNER, PastelBlocks.CREATIVE_PARTICLE_SPAWNER});
        COMPACTING_CHEST = PastelBlockEntities.register("compacting_chest", CompactingChestBlockEntity::new, new Supplier[]{PastelBlocks.COMPACTING_CHEST});
        FABRICATION_CHEST = PastelBlockEntities.register("fabrication_chest", FabricationChestBlockEntity::new, new Supplier[]{PastelBlocks.FABRICATION_CHEST});
        HEARTBOUND_CHEST = PastelBlockEntities.register("heartbound_chest", HeartboundChestBlockEntity::new, new Supplier[]{PastelBlocks.HEARTBOUND_CHEST});
        BLACK_HOLE_CHEST = PastelBlockEntities.register("black_hole_chest", BlackHoleChestBlockEntity::new, new Supplier[]{PastelBlocks.BLACK_HOLE_CHEST});
        PRESERVATION_CHEST = PastelBlockEntities.register("preservation_chest", TreasureChestBlockEntity::new, new Supplier[]{PastelBlocks.PRESERVATION_CHEST});
        AMPHORA = PastelBlockEntities.register("amphora", AmphoraBlockEntity::new, new Supplier[]{PastelBlocks.CHESTNUT_NOXWOOD_AMPHORA, PastelBlocks.EBONY_NOXWOOD_AMPHORA, PastelBlocks.SLATE_NOXWOOD_AMPHORA, PastelBlocks.IVORY_NOXWOOD_AMPHORA, PastelBlocks.WEEPING_GALA_AMPHORA});
        PROJECTOR = PastelBlockEntities.register("projector", ProjectorBlockEntity::new, new Supplier[]{PastelBlocks.PYRITE_PROJECTOR});
        PLAYER_DETECTOR = PastelBlockEntities.register("player_detector", PlayerDetectorBlockEntity::new, new Supplier[]{PastelBlocks.PLAYER_DETECTOR});
        REDSTONE_CALCULATOR = PastelBlockEntities.register("redstone_calculator", RedstoneCalculatorBlockEntity::new, new Supplier[]{PastelBlocks.REDSTONE_CALCULATOR});
        REDSTONE_TRANSCEIVER = PastelBlockEntities.register("redstone_transceiver", RedstoneTransceiverBlockEntity::new, new Supplier[]{PastelBlocks.REDSTONE_TRANSCEIVER});
        BLOCK_PLACER = PastelBlockEntities.register("block_placer", BlockPlacerBlockEntity::new, new Supplier[]{PastelBlocks.BLOCK_PLACER});
        BLOCK_BREAKER = PastelBlockEntities.register("block_breaker", BlockBreakerBlockEntity::new, new Supplier[]{PastelBlocks.BLOCK_BREAKER});
        BLOCK_FLOODER = PastelBlockEntities.register("block_flooder", BlockFlooderBlockEntity::new, new Supplier[]{PastelBlocks.BLOCK_FLOODER});
        BOTTOMLESS_BUNDLE = PastelBlockEntities.register("bottomless_bundle", BottomlessBundleBlockEntity::new, new Supplier[]{PastelBlocks.BOTTOMLESS_BUNDLE});
        POTION_WORKSHOP = PastelBlockEntities.register("potion_workshop", PotionWorkshopBlockEntity::new, new Supplier[]{PastelBlocks.POTION_WORKSHOP});
        SPIRIT_INSTILLER = PastelBlockEntities.register("spirit_instiller", SpiritInstillerBlockEntity::new, new Supplier[]{PastelBlocks.SPIRIT_INSTILLER});
        MEMORY = PastelBlockEntities.register("memory", MemoryBlockEntity::new, new Supplier[]{PastelBlocks.MEMORY});
        JADE_VINE_ROOTS = PastelBlockEntities.register("jade_vine_roots", JadeVineRootsBlockEntity::new, new Supplier[]{PastelBlocks.JADE_VINE_ROOTS});
        CRYSTALLARIEUM = PastelBlockEntities.register("crystallarieum", CrystallarieumBlockEntity::new, new Supplier[]{PastelBlocks.CRYSTALLARIEUM});
        CRYSTAL_APOTHECARY = PastelBlockEntities.register("crystal_apothecary", CrystalApothecaryBlockEntity::new, new Supplier[]{PastelBlocks.CRYSTAL_APOTHECARY});
        COLOR_PICKER = PastelBlockEntities.register("color_picker", ColorPickerBlockEntity::new, new Supplier[]{PastelBlocks.COLOR_PICKER});
        CINDERHEARTH = PastelBlockEntities.register("cinderhearth", CinderhearthBlockEntity::new, new Supplier[]{PastelBlocks.CINDERHEARTH});
        PRESENT = PastelBlockEntities.register("present", PresentBlockEntity::new, new Supplier[]{PastelBlocks.PRESENT});
        TITRATION_BARREL = PastelBlockEntities.register("titration_barrel", TitrationBarrelBlockEntity::new, new Supplier[]{PastelBlocks.TITRATION_BARREL});
        PASTEL_NODE = PastelBlockEntities.register("pastel_node", PastelNodeBlockEntity::new, new Supplier[]{PastelBlocks.CONNECTION_NODE, PastelBlocks.PROVIDER_NODE, PastelBlocks.STORAGE_NODE, PastelBlocks.SENDER_NODE, PastelBlocks.GATHER_NODE, PastelBlocks.BUFFER_NODE});
        HUMMINGSTONE = PastelBlockEntities.register("hummingstone", HummingstoneBlockEntity::new, new Supplier[]{PastelBlocks.HUMMINGSTONE});
        PLACED_ITEM = PastelBlockEntities.register("placed_item", PlacedItemBlockEntity::new, new Supplier[]{PastelBlocks.INCANDESCENT_AMALGAM, PastelBlocks.COLORFUL_SHOOTING_STAR, PastelBlocks.FIERY_SHOOTING_STAR, PastelBlocks.GEMSTONE_SHOOTING_STAR, PastelBlocks.GLISTERING_SHOOTING_STAR, PastelBlocks.PRISTINE_SHOOTING_STAR});
        PRESERVATION_CONTROLLER = PastelBlockEntities.register("preservation_controller", PreservationControllerBlockEntity::new, new Supplier[]{PastelBlocks.PRESERVATION_CONTROLLER});
        PRESERVATION_ROUNDEL = PastelBlockEntities.register("preservation_roundel", PreservationRoundelBlockEntity::new, new Supplier[]{PastelBlocks.PRESERVATION_ROUNDEL});
        PRESERVATION_BLOCK_DETECTOR = PastelBlockEntities.register("preservation_block_detector", PreservationBlockDetectorBlockEntity::new, new Supplier[]{PastelBlocks.PRESERVATION_BLOCK_DETECTOR});
        DEEP_LIGHT = PastelBlockEntities.register("deep_light", DeepLightBlockEntity::new, new Supplier[]{PastelBlocks.DEEP_LIGHT_CHISELED_PRESERVATION_STONE});
        PLAYER_TRACKING = PastelBlockEntities.register("player_tracking", PlayerTrackerBlockEntity::new, new Supplier[]{PastelBlocks.MANXI, PastelBlocks.TREASURE_ITEM_BOWL});
        List<DeferredBlock<Block>> upgradeBlocksList = List.of(PastelBlocks.UPGRADE_SPEED, PastelBlocks.UPGRADE_SPEED2, PastelBlocks.UPGRADE_SPEED3, PastelBlocks.UPGRADE_EFFICIENCY, PastelBlocks.UPGRADE_EFFICIENCY2, PastelBlocks.UPGRADE_YIELD, PastelBlocks.UPGRADE_YIELD2, PastelBlocks.UPGRADE_EXPERIENCE, PastelBlocks.UPGRADE_EXPERIENCE2);
        UPGRADE_BLOCK = PastelBlockEntities.register("upgrade_block", UpgradeBlockEntity::new, upgradeBlocksList.toArray(new Supplier[0]));
        REGISTER.register(bus);
    }

    public static void registerAdditionalTypes(BlockEntityTypeAddBlocksEvent event) {
        event.modify(BlockEntityType.BARREL, new Block[]{(Block)PastelBlocks.WEEPING_GALA_BARREL.get()});
        ArrayList<Block> skullBlocksList = new ArrayList<Block>(PastelSkullBlock.getMobHeads().size() + PastelWallSkullBlock.getMobWallHeads().size());
        skullBlocksList.addAll(PastelSkullBlock.getMobHeads());
        skullBlocksList.addAll(PastelWallSkullBlock.getMobWallHeads());
        event.modify(BlockEntityType.SKULL, skullBlocksList.toArray(new Block[0]));
    }

    public static void registerClient(FMLClientSetupEvent event) {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)PEDESTAL.get()), PedestalBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BOTTOMLESS_BUNDLE.get()), BottomlessBundleBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)HEARTBOUND_CHEST.get()), HeartboundChestBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)COMPACTING_CHEST.get()), CompactingChestBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FABRICATION_CHEST.get()), FabricationChestBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)PRESERVATION_CHEST.get()), PastelChestBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BLACK_HOLE_CHEST.get()), BlackHoleChestBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)UPGRADE_BLOCK.get()), UpgradeBlockBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)FUSION_SHRINE.get()), FusionShrineBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ENCHANTER.get()), EnchanterBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ITEM_BOWL.get()), ItemBowlBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ITEM_ROUNDEL.get()), ItemRoundelBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)PRESERVATION_ROUNDEL.get()), ItemRoundelBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)SPIRIT_INSTILLER.get()), SpiritInstillerBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)JADE_VINE_ROOTS.get()), JadeVineRootsBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CRYSTALLARIEUM.get()), CrystallarieumBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)COLOR_PICKER.get()), ColorPickerBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)PRESERVATION_CONTROLLER.get()), PreservationControllerBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)PROJECTOR.get()), ProjectorBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)DEEP_LIGHT.get()), DeepLightBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)PLAYER_TRACKING.get()), PlayerTrackingBlockEntityRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)PASTEL_NODE.get()), PastelNodeBlockEntityRenderer::new);
    }
}

