/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.titration_barrel.dynamic;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.components.BeverageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import earth.terrarium.pastel.recipe.FluidRecipeInput;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationData;
import earth.terrarium.pastel.recipe.titration_barrel.TitrationBarrelRecipe;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public class SuspiciousBrewRecipe
extends TitrationBarrelRecipe {
    public static final Item TAPPING_ITEM = Items.GLASS_BOTTLE;
    public static final int MIN_FERMENTATION_TIME_HOURS = 4;
    public static final ItemStack OUTPUT_STACK = SuspiciousBrewRecipe.getDefaultStackWithCount((Item)PastelItems.SUSPICIOUS_BREW.get(), 4);
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("unlocks/food/suspicious_brew");
    public static final List<IngredientStack> INGREDIENT_STACKS = new ArrayList<IngredientStack>(){
        {
            this.add(IngredientStack.ofTag((TagKey<Item>)ItemTags.SMALL_FLOWERS, 1));
            this.add(IngredientStack.ofTag((TagKey<Item>)ItemTags.SMALL_FLOWERS, 1));
            this.add(IngredientStack.ofTag((TagKey<Item>)ItemTags.SMALL_FLOWERS, 1));
            this.add(IngredientStack.ofTag((TagKey<Item>)ItemTags.SMALL_FLOWERS, 1));
        }
    };

    public SuspiciousBrewRecipe() {
        super("", false, Optional.of(UNLOCK_IDENTIFIER), INGREDIENT_STACKS, FluidIngredient.of((Fluid[])new Fluid[]{Fluids.WATER}), OUTPUT_STACK, TAPPING_ITEM, 4, new FermentationData(1.25f, 0.01f, List.of()));
    }

    @Override
    public ItemStack getPreviewTap(int timeMultiplier) {
        ItemStack flowerStack = Items.POPPY.getDefaultInstance();
        flowerStack.setCount(4);
        return this.tapWith(List.of(flowerStack), 1.0f, (long)this.minFermentationTimeHours * 60L * 60L * (long)timeMultiplier, 0.4f);
    }

    @Override
    public ItemStack tap(FriendlyStackHandler inventory, long secondsFermented, float downfall) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int itemCount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
            itemCount += stack.getCount();
        }
        float thickness = this.getThickness(itemCount);
        return this.tapWith(stacks, thickness, secondsFermented, downfall);
    }

    public ItemStack tapWith(List<ItemStack> stacks, float thickness, long secondsFermented, float downfall) {
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        double alcPercent = SuspiciousBrewRecipe.getAlcPercent(this.fermentationData.fermentationSpeedMod(), thickness, downfall, ageIngameDays);
        if (alcPercent >= 100.0) {
            return ((Item)PastelItems.PURE_ALCOHOL.get()).getDefaultInstance();
        }
        HashMap<Holder, Double> stewEffects = new HashMap<Holder, Double>();
        for (ItemStack stack : stacks) {
            SuspiciousStewEffects stewEffectsComponent = SuspiciousStewEffects.EMPTY;
            Item item = stack.getItem();
            if (item instanceof SuspiciousEffectHolder) {
                SuspiciousEffectHolder sussyBakka = (SuspiciousEffectHolder)item;
                stewEffectsComponent = sussyBakka.getSuspiciousEffects();
            }
            for (SuspiciousStewEffects.Entry entry : stewEffectsComponent.effects()) {
                Holder key = entry.effect();
                double duration = (double)entry.duration() * Support.logBase(2.0, 1 + stack.getCount());
                stewEffects.put(key, stewEffects.getOrDefault(key, 0.0) + duration);
            }
        }
        ArrayList<MobEffectInstance> finalStatusEffects = new ArrayList<MobEffectInstance>();
        double clampedAlcPercent = Mth.clamp((double)alcPercent, (double)1.0, (double)20.0);
        for (Map.Entry entry : stewEffects.entrySet()) {
            double finalDurationTicks = (Double)entry.getValue() * Math.pow(2.0, clampedAlcPercent);
            finalStatusEffects.add(new MobEffectInstance((Holder)entry.getKey(), (int)finalDurationTicks, 0));
        }
        ItemStack outputStack = OUTPUT_STACK.copy();
        outputStack.setCount(1);
        outputStack.set(PastelDataComponentTypes.BEVERAGE, (Object)new BeverageComponent((long)ageIngameDays, (int)alcPercent, thickness));
        outputStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), finalStatusEffects));
        return outputStack;
    }

    @Override
    public boolean matches(FluidRecipeInput<FluidTank> recipeInput, Level world) {
        boolean flowerFound = false;
        for (int i = 0; i < recipeInput.size(); ++i) {
            BlockItem blockItem;
            ItemStack stack = recipeInput.getItem(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof FlowerBlock) {
                flowerFound = true;
                continue;
            }
            return false;
        }
        return flowerFound;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.TITRATION_BARREL_SUSPICIOUS_BREW;
    }
}

