/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.titration_barrel;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.components.BeverageComponent;
import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import earth.terrarium.pastel.helpers.render.LoreHelper;
import earth.terrarium.pastel.recipe.FluidRecipeInput;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationData;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public interface ITitrationBarrelRecipe
extends GatedRecipe<FluidRecipeInput<FluidTank>> {
    public static final ResourceLocation UNLOCK_ADVANCEMENT_IDENTIFIER = PastelCommon.locate("unlocks/blocks/titration_barrel");

    default public ItemStack getTitrationResult(FriendlyStackHandler inventory, long secondsFermented, float downfall) {
        if (secondsFermented < 0L) {
            float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
            List<MobEffectInstance> statusEffects = List.of(new MobEffectInstance(MobEffects.INVISIBILITY, 3600, 0));
            ItemStack stack = ((Item)PastelItems.SUSPICIOUS_BREW.get()).getDefaultInstance();
            stack.set(PastelDataComponentTypes.BEVERAGE, (Object)new BeverageComponent((long)ageIngameDays, 0, 0.0f));
            stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), statusEffects));
            LoreHelper.setLore(stack, (Component)Component.translatable((String)"lore.pastel.time_travel_tap"));
            return stack;
        }
        return this.tap(inventory, secondsFermented, downfall);
    }

    public ItemStack tap(FriendlyStackHandler var1, long var2, float var4);

    public Item getTappingItem();

    public FluidIngredient getFluidInput();

    public float getAngelsSharePerMcDay();

    default public int getOutputCountAfterAngelsShare(Level world, float temperature, long secondsFermented) {
        int originalOutputCount = this.getResultItem((HolderLookup.Provider)world.registryAccess()).getCount();
        if (this.getFermentationData() == null) {
            return originalOutputCount;
        }
        float angelsShareResultCountMod = this.getAngelsShareResultCountMod(secondsFermented, temperature);
        if (angelsShareResultCountMod > 0.0f) {
            return Math.max(1, (int)Math.ceil((float)originalOutputCount - angelsShareResultCountMod));
        }
        return Math.max(1, (int)Math.floor((float)originalOutputCount - angelsShareResultCountMod));
    }

    default public float getAngelsShareResultCountMod(long secondsFermented, float temperature) {
        return Math.max(0.1f, temperature / 10.0f) * TimeHelper.minecraftDaysFromSeconds(secondsFermented) * this.getAngelsSharePerMcDay();
    }

    default public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    default public ItemStack getToastSymbol() {
        return ((Block)PastelBlocks.TITRATION_BARREL.get()).asItem().getDefaultInstance();
    }

    default public RecipeType<?> getType() {
        return PastelRecipeTypes.TITRATION_BARREL;
    }

    public List<IngredientStack> getIngredientStacks();

    public int getMinFermentationTimeHours();

    default public boolean isFermentingLongEnoughToTap(long secondsFermented) {
        return secondsFermented / 60L / 60L >= (long)this.getMinFermentationTimeHours();
    }

    public FermentationData getFermentationData();
}

