/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.spirit_instiller;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.memory.MemoryItem;
import earth.terrarium.pastel.blocks.spirit_instiller.SpiritInstillerBlockEntity;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.GatedStackPastelRecipe;
import earth.terrarium.pastel.recipe.InstanceRecipeInput;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SpiritInstillerRecipe
extends GatedStackPastelRecipe<InstanceRecipeInput<SpiritInstillerBlockEntity>> {
    public static final int CENTER = 0;
    public static final int FIRST = 1;
    public static final int SECOND = 2;
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("midgame/build_spirit_instiller_structure");
    protected final IngredientStack centerIngredient;
    protected final IngredientStack bowlIngredient1;
    protected final IngredientStack bowlIngredient2;
    protected final ItemStack output;
    protected final int craftingTime;
    protected final float experience;
    protected final boolean noBenefitsFromYieldAndEfficiencyUpgrades;

    public SpiritInstillerRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, IngredientStack centerIngredient, IngredientStack bowlIngredient1, IngredientStack bowlIngredient2, ItemStack output, int craftingTime, float experience, boolean noBenefitsFromYieldAndEfficiencyUpgrades) {
        super(group, secret, requiredAdvancementIdentifier);
        this.centerIngredient = centerIngredient;
        this.bowlIngredient1 = bowlIngredient1;
        this.bowlIngredient2 = bowlIngredient2;
        this.output = output;
        this.craftingTime = craftingTime;
        this.experience = experience;
        this.noBenefitsFromYieldAndEfficiencyUpgrades = noBenefitsFromYieldAndEfficiencyUpgrades;
        this.registerInToastManager(this.getType(), this);
    }

    public boolean matches(InstanceRecipeInput input, Level world) {
        List<IngredientStack> ing = this.getIngredientStacks();
        if (this.bowlMatches(input)) {
            return ing.getFirst().test(input.getItem(0));
        }
        return false;
    }

    protected boolean bowlMatches(InstanceRecipeInput<?> input) {
        List<IngredientStack> ing = this.getIngredientStacks();
        if (ing.get(1).test(input.getItem(1)) && ing.get(2).test(input.getItem(2))) {
            return true;
        }
        return ing.get(1).test(input.getItem(2)) && ing.get(2).test(input.getItem(1));
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.SPIRIT_INSTILLING_SERIALIZER;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.centerIngredient);
        defaultedList.add((Object)this.bowlIngredient1);
        defaultedList.add((Object)this.bowlIngredient2);
        return defaultedList;
    }

    public ItemStack assemble(InstanceRecipeInput<SpiritInstillerBlockEntity> recipeInput, HolderLookup.Provider drm) {
        boolean makeUnrecognizable;
        SpiritInstillerBlockEntity spiritInstillerBlockEntity = recipeInput.getInstance();
        Upgradeable.UpgradeHolder upgradeHolder = spiritInstillerBlockEntity.getUpgradeHolder();
        Level world = spiritInstillerBlockEntity.getLevel();
        if (world == null) {
            return ItemStack.EMPTY;
        }
        BlockPos pos = spiritInstillerBlockEntity.getBlockPos();
        ItemStack resultStack = this.getResultItem(drm).copy();
        if (!this.areYieldAndEfficiencyUpgradesDisabled() && (double)upgradeHolder.getEffectiveValue(Upgradeable.UpgradeType.YIELD) != 1.0) {
            int resultCountMod = Support.chanceRound((float)resultStack.getCount() * upgradeHolder.getEffectiveValue(Upgradeable.UpgradeType.YIELD), world.random);
            resultStack.setCount(resultCountMod);
        }
        if (resultStack.is(((Block)PastelBlocks.MEMORY.get()).asItem()) && (makeUnrecognizable = spiritInstillerBlockEntity.getItem(0).is(PastelItemTags.MEMORY_BONDING_AGENTS_CONCEALABLE))) {
            MemoryItem.makeUnrecognizable(resultStack);
        }
        this.spawnXPAndGrantAdvancements(resultStack, spiritInstillerBlockEntity, upgradeHolder, world, pos);
        return resultStack;
    }

    protected void spawnXPAndGrantAdvancements(ItemStack resultStack, SpiritInstillerBlockEntity instiller, Upgradeable.UpgradeHolder upgradeHolder, Level world, BlockPos pos) {
        int awardedExperience = 0;
        if (this.getExperience() > 0.0f) {
            double experienceModifier = upgradeHolder.getEffectiveValue(Upgradeable.UpgradeType.EXPERIENCE);
            float recipeExperienceBeforeMod = this.getExperience();
            awardedExperience = Support.chanceRound((double)recipeExperienceBeforeMod * experienceModifier, world.random);
            MultiblockCrafter.spawnExperience(world, pos.above(), awardedExperience);
        }
        this.grantPlayerSpiritInstillingAdvancementCriterion((ServerLevel)instiller.getLevel(), instiller.getBlockPos(), resultStack, awardedExperience);
    }

    protected void grantPlayerSpiritInstillingAdvancementCriterion(ServerLevel level, BlockPos pos, ItemStack resultStack, int experience) {
        Support.areaCriterion(level, 16, pos, this.requiredAdvancementIdentifier, p -> PastelCriteria.SPIRIT_INSTILLER_CRAFTING.trigger((ServerPlayer)p, resultStack, experience));
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public boolean areYieldAndEfficiencyUpgradesDisabled() {
        return this.noBenefitsFromYieldAndEfficiencyUpgrades;
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "spirit_instiller";
    }

    public boolean canCraftWithStacks(RecipeInput inventory, Level level) {
        return true;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.SPIRIT_INSTILLER.get());
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.SPIRIT_INSTILLING;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 3;
    }

    public static class Serializer
    implements RecipeSerializer<SpiritInstillerRecipe> {
        public static final MapCodec<SpiritInstillerRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)IngredientStack.CODEC.fieldOf("center_ingredient").forGetter(recipe -> recipe.centerIngredient), (App)IngredientStack.CODEC.fieldOf("ingredient1").forGetter(recipe -> recipe.bowlIngredient1), (App)IngredientStack.CODEC.fieldOf("ingredient2").forGetter(recipe -> recipe.bowlIngredient2), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.BOOL.optionalFieldOf("disable_yield_and_efficiency_upgrades", (Object)false).forGetter(recipe -> recipe.noBenefitsFromYieldAndEfficiencyUpgrades)).apply((Applicative)i, SpiritInstillerRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SpiritInstillerRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, c -> c.group, ByteBufCodecs.BOOL, c -> c.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> c.requiredAdvancementIdentifier, IngredientStack.STREAM_CODEC, c -> c.centerIngredient, IngredientStack.STREAM_CODEC, c -> c.bowlIngredient1, IngredientStack.STREAM_CODEC, c -> c.bowlIngredient2, ItemStack.STREAM_CODEC, c -> c.output, ByteBufCodecs.VAR_INT, recipe -> recipe.craftingTime, ByteBufCodecs.FLOAT, recipe -> Float.valueOf(recipe.experience), ByteBufCodecs.BOOL, recipe -> recipe.noBenefitsFromYieldAndEfficiencyUpgrades, SpiritInstillerRecipe::new);

        public MapCodec<SpiritInstillerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SpiritInstillerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

