/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.potion_workshop;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.potion_workshop.PotionMod;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PotionRecipeEffect(boolean applicableToPotions, boolean applicableToTippedArrows, boolean applicableToPotionFillabes, boolean applicableToWeapons, int baseDurationTicks, float baseYield, int potencyHardCap, float potencyModifier, Holder<MobEffect> statusEffect, InkColor inkColor, int inkCost) {
    public static MapCodec<PotionRecipeEffect> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("applicable_to_potions", (Object)true).forGetter(PotionRecipeEffect::applicableToPotions), (App)Codec.BOOL.optionalFieldOf("applicable_to_tipped_arrows", (Object)true).forGetter(PotionRecipeEffect::applicableToTippedArrows), (App)Codec.BOOL.optionalFieldOf("applicable_to_potion_fillabes", (Object)true).forGetter(PotionRecipeEffect::applicableToPotionFillabes), (App)Codec.BOOL.optionalFieldOf("applicable_to_weapons", (Object)true).forGetter(PotionRecipeEffect::applicableToWeapons), (App)Codec.INT.optionalFieldOf("base_duration_ticks", (Object)1600).forGetter(PotionRecipeEffect::baseDurationTicks), (App)Codec.FLOAT.optionalFieldOf("base_yield", (Object)Float.valueOf(3.0f)).forGetter(PotionRecipeEffect::baseYield), (App)Codec.INT.optionalFieldOf("potency_hard_cap", (Object)-1).forGetter(PotionRecipeEffect::potencyHardCap), (App)Codec.FLOAT.optionalFieldOf("potency_modifier", (Object)Float.valueOf(1.0f)).forGetter(PotionRecipeEffect::potencyModifier), (App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(PotionRecipeEffect::statusEffect), (App)InkColor.CODEC.fieldOf("ink_color").forGetter(PotionRecipeEffect::inkColor), (App)Codec.INT.fieldOf("ink_cost").forGetter(PotionRecipeEffect::inkCost)).apply((Applicative)i, PotionRecipeEffect::new));
    public static StreamCodec<RegistryFriendlyByteBuf, PotionRecipeEffect> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.BOOL, PotionRecipeEffect::applicableToPotions, ByteBufCodecs.BOOL, PotionRecipeEffect::applicableToTippedArrows, ByteBufCodecs.BOOL, PotionRecipeEffect::applicableToPotionFillabes, ByteBufCodecs.BOOL, PotionRecipeEffect::applicableToWeapons, ByteBufCodecs.VAR_INT, PotionRecipeEffect::baseDurationTicks, ByteBufCodecs.FLOAT, PotionRecipeEffect::baseYield, ByteBufCodecs.VAR_INT, PotionRecipeEffect::potencyHardCap, ByteBufCodecs.FLOAT, PotionRecipeEffect::potencyModifier, ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), PotionRecipeEffect::statusEffect, InkColor.STREAM_CODEC, PotionRecipeEffect::inkColor, ByteBufCodecs.VAR_INT, PotionRecipeEffect::inkCost, PotionRecipeEffect::new);

    public static PotionRecipeEffect read(JsonObject jsonObject) {
        return (PotionRecipeEffect)CodecHelper.fromJson(CODEC.codec(), (JsonElement)jsonObject).orElseThrow();
    }

    public void write(RegistryFriendlyByteBuf buf) {
        STREAM_CODEC.encode((Object)buf, (Object)this);
    }

    public static PotionRecipeEffect read(RegistryFriendlyByteBuf buf) {
        return (PotionRecipeEffect)STREAM_CODEC.decode((Object)buf);
    }

    @Nullable
    public InkPoweredStatusEffectInstance getStatusEffectInstance(@NotNull PotionMod potionMod, RandomSource random) {
        float potency = potionMod.flatPotencyBonus();
        int durationTicks = this.baseDurationTicks() + potionMod.flatDurationBonusTicks();
        switch (((MobEffect)this.statusEffect().value()).getCategory()) {
            case BENEFICIAL: {
                potency += potionMod.flatPotencyBonusPositiveEffects();
                durationTicks += potionMod.flatDurationBonusPositiveEffects();
                break;
            }
            case HARMFUL: {
                potency += potionMod.flatPotencyBonusNegativeEffects();
                durationTicks += potionMod.flatDurationBonusNegativeEffects();
                break;
            }
        }
        int n = durationTicks = ((MobEffect)this.statusEffect().value()).isInstantenous() ? 1 : (int)((float)durationTicks * potionMod.durationMultiplier());
        if (this.potencyModifier() == 0.0f) {
            potency = 0.0f;
        } else {
            potency = ((1.0f + potency) * potionMod.potencyMultiplier() - 1.0f) * this.potencyModifier();
            if ((potency = (float)Support.chanceRound(potency, random)) < 0.0f && (double)potionMod.potencyMultiplier() == 0.0) {
                potency = 0.0f;
            }
        }
        if (this.potencyHardCap > -1 && potency > (float)this.potencyHardCap) {
            potency = this.potencyHardCap;
        }
        if (potency >= 0.0f && durationTicks > 0) {
            int effectColor = potionMod.getColor(random);
            return new InkPoweredStatusEffectInstance(new MobEffectInstance(this.statusEffect, durationTicks, (int)potency, !potionMod.flags().noParticles(), !potionMod.flags().noParticles()), new InkCost(this.inkColor(), this.inkCost()), effectColor, potionMod.flags().unidentifiable(), potionMod.flags().incurable());
        }
        return null;
    }

    public boolean isApplicableTo(ItemStack baseIngredient, PotionMod potionMod) {
        if (baseIngredient.is(Items.ARROW)) {
            return this.applicableToTippedArrows && potionMod.flags().makeSplashing() && potionMod.flags().makeLingering();
        }
        Item item = baseIngredient.getItem();
        if (item instanceof InkPoweredPotionFillable) {
            InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)item;
            return this.applicableToPotionFillabes && !inkPoweredPotionFillable.isFull(baseIngredient) || this.applicableToWeapons && inkPoweredPotionFillable.isWeapon();
        }
        return this.applicableToPotions;
    }
}

