/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.pedestal;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockItem;
import earth.terrarium.pastel.blocks.pedestal.PedestalRecipeInput;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.recipe.GatedStackPastelRecipe;
import earth.terrarium.pastel.recipe.pedestal.PastelGemstoneColor;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class PedestalRecipe
extends GatedStackPastelRecipe<PedestalRecipeInput> {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("place_pedestal");
    public static final int[] CRAFTING_GRID_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    protected final PedestalTier tier;
    protected final List<IngredientStack> inputs;
    protected final Map<GemstoneColor, Integer> powderInputs;
    protected final ItemStack output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean skipRecipeRemainders;
    protected final boolean noBenefitsFromYieldUpgrades;

    public PedestalRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, PedestalTier tier, List<IngredientStack> inputs, Map<GemstoneColor, Integer> powderInputs, ItemStack output, float experience, int craftingTime, boolean skipRecipeRemainders, boolean noBenefitsFromYieldUpgrades) {
        super(group, secret, requiredAdvancementIdentifier);
        this.tier = tier;
        this.inputs = inputs;
        this.powderInputs = powderInputs;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.skipRecipeRemainders = skipRecipeRemainders;
        this.noBenefitsFromYieldUpgrades = noBenefitsFromYieldUpgrades;
        this.registerInToastManager(this.getType(), this);
    }

    public boolean isStructureUpgrade(RegistryAccess access) {
        return this.getResultItem((HolderLookup.Provider)access).getItem() instanceof PedestalBlockItem;
    }

    public boolean matches(PedestalRecipeInput inv, Level world) {
        int topazPowderAmount = this.powderInputs.getOrDefault(PastelGemstoneColor.CYAN, 0);
        int amethystPowderAmount = this.powderInputs.getOrDefault(PastelGemstoneColor.MAGENTA, 0);
        int citrinePowderAmount = this.powderInputs.getOrDefault(PastelGemstoneColor.YELLOW, 0);
        int onyxPowderAmount = this.powderInputs.getOrDefault(PastelGemstoneColor.BLACK, 0);
        int moonstonePowderAmount = this.powderInputs.getOrDefault(PastelGemstoneColor.WHITE, 0);
        return !(topazPowderAmount != 0 && !this.isStackAtLeast(inv.getItem(9), (Item)PastelItems.TOPAZ_POWDER.get(), topazPowderAmount) || amethystPowderAmount != 0 && !this.isStackAtLeast(inv.getItem(10), (Item)PastelItems.AMETHYST_POWDER.get(), amethystPowderAmount) || citrinePowderAmount != 0 && !this.isStackAtLeast(inv.getItem(11), (Item)PastelItems.CITRINE_POWDER.get(), citrinePowderAmount) || onyxPowderAmount != 0 && !this.isStackAtLeast(inv.getItem(12), (Item)PastelItems.ONYX_POWDER.get(), onyxPowderAmount) || moonstonePowderAmount != 0 && !this.isStackAtLeast(inv.getItem(13), (Item)PastelItems.MOONSTONE_POWDER.get(), moonstonePowderAmount));
    }

    private boolean isStackAtLeast(ItemStack sourceItemStack, Item item, int amount) {
        return sourceItemStack.is(item) && sourceItemStack.getCount() >= amount;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.inputs;
    }

    public ItemStack assemble(PedestalRecipeInput inventory, HolderLookup.Provider registryManager) {
        return this.output.copy();
    }

    public PedestalTier getTier() {
        return this.tier;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.PEDESTAL_BASIC_AMETHYST.get());
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.PEDESTAL;
    }

    public int getPowder(GemstoneColor gemstoneColor) {
        return this.powderInputs.getOrDefault(gemstoneColor, 0);
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public Map<GemstoneColor, Integer> getPowderInputs() {
        return this.powderInputs;
    }

    public SoundEvent getSoundEvent(RandomSource random) {
        int i;
        ArrayList<SoundEvent> choices = new ArrayList<SoundEvent>();
        for (i = 0; i < this.powderInputs.getOrDefault(PastelGemstoneColor.MAGENTA, 0); ++i) {
            choices.add(PastelSounds.PEDESTAL_CRAFTING_FINISHED_AMETHYST);
        }
        for (i = 0; i < this.powderInputs.getOrDefault(PastelGemstoneColor.YELLOW, 0); ++i) {
            choices.add(PastelSounds.PEDESTAL_CRAFTING_FINISHED_CITRINE);
        }
        for (i = 0; i < this.powderInputs.getOrDefault(PastelGemstoneColor.CYAN, 0); ++i) {
            choices.add(PastelSounds.PEDESTAL_CRAFTING_FINISHED_TOPAZ);
        }
        for (i = 0; i < this.powderInputs.getOrDefault(PastelGemstoneColor.BLACK, 0); ++i) {
            choices.add(PastelSounds.PEDESTAL_CRAFTING_FINISHED_ONYX);
        }
        for (i = 0; i < this.powderInputs.getOrDefault(PastelGemstoneColor.WHITE, 0); ++i) {
            choices.add(PastelSounds.PEDESTAL_CRAFTING_FINISHED_MOONSTONE);
        }
        if (choices.isEmpty()) {
            return PastelSounds.PEDESTAL_CRAFTING_FINISHED_GENERIC;
        }
        return (SoundEvent)choices.get(random.nextInt(choices.size()));
    }

    public void consumeIngredients(PedestalBlockEntity pedestal, PedestalRecipeInput input) {
        Level level = pedestal.getLevel();
        FriendlyStackHandler inv = pedestal.getInventory();
        assert (level != null);
        for (PastelGemstoneColor color : PastelGemstoneColor.values()) {
            double efficiency = pedestal.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
            int drain = Support.chanceRound((double)this.getPowder(color) / efficiency, level.random);
            inv.extractItem(PedestalBlockEntity.powderSlot(color), drain, false);
        }
    }

    protected void decrementGridSlot(PedestalBlockEntity pedestal, int slot, int count, ItemStack invStack) {
        ItemStack remainder = this.skipRecipeRemainders() ? ItemStack.EMPTY : invStack.getCraftingRemainingItem();
        remainder.setCount(count);
        FriendlyStackHandler inv = pedestal.getInventory();
        if (pedestal.getLevel() == null) {
            return;
        }
        if (remainder.isEmpty()) {
            invStack.shrink(count);
        } else if (inv.getStackInSlot(slot).getCount() == count) {
            inv.setStackInSlot(slot, remainder);
        } else {
            inv.extractItem(slot, count, false);
            ItemEntity itemEntity = new ItemEntity(pedestal.getLevel(), (double)pedestal.getBlockPos().getX() + 0.5, (double)(pedestal.getBlockPos().getY() + 1), (double)pedestal.getBlockPos().getZ() + 0.5, remainder);
            itemEntity.push(0.0, 0.05, 0.0);
            pedestal.getLevel().addFreshEntity((Entity)itemEntity);
        }
    }

    public boolean canCraft(PedestalBlockEntity pedestal) {
        Player playerEntity = pedestal.getOwnerIfOnline();
        if (playerEntity == null || !this.canPlayerCraft(playerEntity)) {
            return false;
        }
        return pedestal.getTier().ordinal() >= this.tier.ordinal();
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public boolean canPlayerCraft(Player playerEntity) {
        return this.tier.hasUnlocked(playerEntity) && this.requiredAdvancementIdentifier.map(a -> DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)a)).orElse(true) != false;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "pedestal";
    }

    public boolean allowsYield() {
        return this.noBenefitsFromYieldUpgrades;
    }

    public boolean skipRecipeRemainders() {
        return this.skipRecipeRemainders;
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public boolean isShapeless() {
        return true;
    }

    public int getGridSlotId(int index) {
        int width = this.getWidth();
        int x = index % width;
        int y = (index - x) / width;
        return 3 * y + x;
    }
}

