/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.pedestal;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRegistries;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;

public enum PastelGemstoneColor implements GemstoneColor,
StringRepresentable
{
    CYAN("cyan", InkColors.CYAN, 0),
    MAGENTA("magenta", InkColors.MAGENTA, 1),
    YELLOW("yellow", InkColors.YELLOW, 2),
    BLACK("black", InkColors.BLACK, 3),
    WHITE("white", InkColors.WHITE, 4);

    private final int color;
    private final InkColor inkColor;
    private final int offset;

    private PastelGemstoneColor(String name, InkColor color, int offset) {
        this.offset = offset;
        Registry.register(PastelRegistries.GEMSTONE_COLOR, (ResourceLocation)PastelCommon.locate(name), (Object)this);
        this.color = color.getColorInt();
        this.inkColor = color;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public InkColor getInkColor() {
        return this.inkColor;
    }

    @Override
    public Item getPowder() {
        switch (this.ordinal()) {
            case 0: {
                return (Item)PastelItems.TOPAZ_POWDER.get();
            }
            case 1: {
                return (Item)PastelItems.AMETHYST_POWDER.get();
            }
            case 2: {
                return (Item)PastelItems.CITRINE_POWDER.get();
            }
            case 3: {
                return (Item)PastelItems.ONYX_POWDER.get();
            }
            case 4: {
                return (Item)PastelItems.MOONSTONE_POWDER.get();
            }
        }
        throw new RuntimeException("Tried getting powder item for a color which does not have one");
    }

    public String getSerializedName() {
        return this.name();
    }
}

