/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.crafting.dynamic;

import earth.terrarium.pastel.blocks.present.PresentBlock;
import earth.terrarium.pastel.blocks.present.PresentBlockItem;
import earth.terrarium.pastel.items.PigmentItem;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapPresentRecipe
extends CustomRecipe {
    public WrapPresentRecipe() {
        super(CraftingBookCategory.MISC);
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.withSize((int)1, (Object)Ingredient.EMPTY);
        list.set(0, (Object)Ingredient.of((ItemStack[])new ItemStack[]{((Block)PastelBlocks.PRESENT.get()).asItem().getDefaultInstance()}));
        return list;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryLookup) {
        ItemStack stack = ((Block)PastelBlocks.PRESENT.get()).asItem().getDefaultInstance();
        PresentBlockItem.wrap(stack, PresentBlock.WrappingPaper.RED, Map.of());
        return stack;
    }

    public boolean matches(@NotNull CraftingInput input, Level world) {
        boolean presentItemFound = false;
        boolean wrappingItemFound = false;
        for (int j = 0; j < input.size(); ++j) {
            ItemStack itemStack = input.getItem(j);
            if (itemStack.isEmpty()) continue;
            if (itemStack.getItem() instanceof PresentBlockItem) {
                if (presentItemFound || PresentBlockItem.isWrapped(itemStack)) {
                    return false;
                }
                presentItemFound = true;
                continue;
            }
            if (!wrappingItemFound && this.getPresentVariantForStack(itemStack) != null) {
                wrappingItemFound = true;
                continue;
            }
            if (itemStack.getItem() instanceof PigmentItem) continue;
            return false;
        }
        return presentItemFound;
    }

    public ItemStack assemble(@NotNull CraftingInput input, HolderLookup.Provider registryLookup) {
        ItemStack presentStack = ItemStack.EMPTY;
        PresentBlock.WrappingPaper wrappingPaper = PresentBlock.WrappingPaper.RED;
        HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
        for (int j = 0; j < input.size(); ++j) {
            ItemStack stack = input.getItem(j);
            if (stack.getItem() instanceof PresentBlockItem) {
                presentStack = stack.copy();
            } else {
                Item item = stack.getItem();
                if (item instanceof PigmentItem) {
                    PigmentItem pigmentItem = (PigmentItem)item;
                    int color = pigmentItem.getInkColor().getColorInt();
                    if (colors.containsKey(color)) {
                        colors.put(color, (Integer)colors.get(color) + 1);
                    } else {
                        colors.put(color, 1);
                    }
                }
            }
            PresentBlock.WrappingPaper stackWrappingPaper = this.getPresentVariantForStack(stack);
            if (stackWrappingPaper == null) continue;
            wrappingPaper = stackWrappingPaper;
        }
        if (!presentStack.isEmpty()) {
            PresentBlockItem.wrap(presentStack, wrappingPaper, colors);
        }
        return presentStack;
    }

    @Nullable
    public PresentBlock.WrappingPaper getPresentVariantForStack(@NotNull ItemStack stack) {
        Item item = stack.getItem();
        if (item == Items.RED_DYE) {
            return PresentBlock.WrappingPaper.RED;
        }
        if (item == Items.BLUE_DYE) {
            return PresentBlock.WrappingPaper.BLUE;
        }
        if (item == Items.CYAN_DYE) {
            return PresentBlock.WrappingPaper.CYAN;
        }
        if (item == Items.GREEN_DYE) {
            return PresentBlock.WrappingPaper.GREEN;
        }
        if (item == Items.PURPLE_DYE) {
            return PresentBlock.WrappingPaper.PURPLE;
        }
        if (item == Items.CAKE) {
            return PresentBlock.WrappingPaper.CAKE;
        }
        if (stack.is(ItemTags.FLOWERS)) {
            return PresentBlock.WrappingPaper.STRIPED;
        }
        if (item == Items.FIREWORK_STAR) {
            return PresentBlock.WrappingPaper.STARRY;
        }
        if (item == Items.SNOWBALL) {
            return PresentBlock.WrappingPaper.WINTER;
        }
        if (item == Items.SPORE_BLOSSOM) {
            return PresentBlock.WrappingPaper.PRIDE;
        }
        return null;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.WRAP_PRESENT_SERIALIZER;
    }
}

